/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.stockage;

import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.stockage.ExporteurPNG;
import fr.histoiremondiale.histoire.utiles.es.fichiers.Fichiers;
import fr.histoiremondiale.histoire.utiles.exttypes.Chaines;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

public class ExporteurHTML {
    public static final String NOM_REP_IMAGES = "images";
    public static final String ENCODAGE_HTML = "UTF-8";
    private static final String MARQUEUR_TITRE = "###TITRE_PAGE###";
    private static final String DEBUT_HTML = "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>\n<html>\n  <head>\n    <meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n    <title>###TITRE_PAGE###</title>\n  </head>\n<body>\n";
    private static final String FIN_HTML = "</body>\n</html>\n";

    public String exporter(InfosParagrapheNavig infosParagrapheNavig, int n, PointSphere pointSphere, BufferedImage bufferedImage, File file) throws IOException {
        String string = infosParagrapheNavig == null || infosParagrapheNavig.civilisation() == null ? "" : infosParagrapheNavig.civilisation().nom();
        String string2 = string + "$" + n + ".html";
        String string3 = string + "$" + n + ".png";
        String string4 = file.getAbsolutePath();
        File file2 = new File(string4);
        String string5 = file.getAbsolutePath() + File.separator + NOM_REP_IMAGES;
        File file3 = new File(string5);
        if (!Fichiers.creerRepertoires(file2)) {
            JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le r\u00e9pertoire pour la page html : \"" + file2 + "\"", "Erreur lors de l'exportation de la carte", 0);
            return null;
        }
        if (!Fichiers.creerRepertoires(file3)) {
            JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le r\u00e9pertoire pour l'image : \"" + file2 + "\"", "Erreur lors de l'exportation de la carte", 0);
            return null;
        }
        String string6 = infosParagrapheNavig == null ? "" : infosParagrapheNavig.codeHtmlSimple();
        string6 = Chaines.saufEntreMarqueurs(string6, "<a ", ">");
        string6 = string6.replace("</a>", "");
        String string7 = string + " " + n;
        String string8 = DEBUT_HTML.replace(MARQUEUR_TITRE, string7) + "<div align = \"center\">\n<img src=\"./images/" + string3 + "\" alt=\"Carte\"><br>\n<center><i>" + string + " " + pointSphere.enChaineElaboree() + " en " + n + "</i></center>\n</div>\n<br><div align = \"justify\">\n" + string6 + "\n</div>\n" + FIN_HTML;
        String string9 = file2.getAbsolutePath() + File.separator + string2;
        Fichiers.sauverContenuTexte(string8, string9, ENCODAGE_HTML);
        String string10 = file3.getAbsolutePath() + File.separator + string3;
        new ExporteurPNG().exporter(bufferedImage, string10);
        return string9;
    }
}

