/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique;

import fr.histoiremondiale.histoire.DonneesIGraphique;
import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.igraphique.BouchonParagraphesNavig;
import fr.histoiremondiale.histoire.igraphique.PanParagraphes;
import fr.histoiremondiale.histoire.igraphique.ParagrapheNavig;
import fr.histoiremondiale.histoire.igraphique.TexteCivilisationSelectionnee;
import fr.histoiremondiale.histoire.igraphique.composants.CaseACocher;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.gestplacement.PlaceurListe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;

public class PanNavigateur
extends JPanel
implements ChangeListener,
ComponentListener,
Observer {
    private static final int HAUTEUR_LIGNE = 13;
    public JScrollPane vuedefil_paragraphes;
    public JCheckBox cc_suiviCivilisation;
    private Box p_paragraphes;
    private List<ParagrapheNavig> paragraphesEnCreation;
    private List<ParagrapheNavig> paragraphes;
    private InfosParagrapheNavig demandeAffParagrapheEnAttente;
    private boolean marqueurPremApplicationAffParagraphe = true;
    private boolean marqueurDeuxApplicationAffParagraphe = true;
    private boolean reactionChangementAnneeDesactivee;
    private ParagrapheNavig parAfficheAvantRedim;
    private int posDansParAffiche = -1;
    private int cptRedim;
    private Long dateDebCreationParagraphes = null;
    private long tempsRecupInfosCreation = 0L;
    private long tempsConsommeCreation = 0L;

    public PanNavigateur() {
        EtatAppli etatAppli = HistoireMondiale.instance().etat();
        JPanel jPanel = new JPanel(new PlaceurListe(2, 3L));
        this.cc_suiviCivilisation = new CaseACocher(etatAppli, "suiviCivilisationSelectionnee");
        jPanel.add(this.cc_suiviCivilisation);
        String string = "<html><body><div style=\"text-align : center\">Si cette case est coch\u00e9e, le navigateur suit la civilisation s\u00e9lectionn\u00e9e quand l'ann\u00e9e change.</div></body></html>";
        this.cc_suiviCivilisation.setToolTipText(string);
        jPanel.add(new TexteCivilisationSelectionnee(""));
        this.p_paragraphes = new PanParagraphes(1);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        this.vuedefil_paragraphes = new JScrollPane(this.p_paragraphes, 22, 31);
        jPanel2.add(this.vuedefil_paragraphes);
        this.vuedefil_paragraphes.getViewport().addChangeListener(this);
        this.p_paragraphes.addComponentListener(this);
        this.vuedefil_paragraphes.getVerticalScrollBar().setUnitIncrement(13);
        JLabel jLabel = new JLabel("Chargement des paragraphes en cours...");
        jLabel.setFont(this.getFont().deriveFont(2));
        this.p_paragraphes.add(jLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "South");
        this.paragraphesEnCreation = new ArrayList<ParagrapheNavig>();
        this.paragraphes = new ArrayList<ParagrapheNavig>();
        this.centrerSurCivilisationSuivie();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanNavigateur.this.creerComposantsParagraphes();
            }
        });
        HistoireMondiale.instance().etat().addObserver(this);
    }

    public List<ParagrapheNavig> paragraphes() {
        return this.paragraphes;
    }

    private void creerComposantsParagraphes() {
        if (this.dateDebCreationParagraphes == null) {
            this.dateDebCreationParagraphes = System.currentTimeMillis();
        }
        long l = System.currentTimeMillis();
        List<InfosParagrapheNavig> list = HistoireMondiale.instance().donneesIGraphique().paragraphes();
        int n = list.size();
        int n2 = this.paragraphesEnCreation.size();
        long l2 = System.currentTimeMillis();
        this.tempsRecupInfosCreation += l2 - l;
        if (n2 < n) {
            long l3 = System.currentTimeMillis();
            InfosParagrapheNavig infosParagrapheNavig = list.get(n2);
            ParagrapheNavig paragrapheNavig = new ParagrapheNavig(infosParagrapheNavig);
            paragrapheNavig.setEditable(false);
            paragrapheNavig.setContentType("text/html");
            paragrapheNavig.setText(infosParagrapheNavig.codeHtml());
            this.paragraphesEnCreation.add(paragrapheNavig);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanNavigateur.this.creerComposantsParagraphes();
                }
            });
            long l4 = System.currentTimeMillis();
            this.tempsConsommeCreation += l4 - l3;
            ++n2;
        } else {
            long l5 = System.currentTimeMillis();
            System.out.println("Temps de cr\u00e9ation des paragraphes                : " + (l5 - this.dateDebCreationParagraphes) + " ms.");
            System.out.println("Temps r\u00e9ellement consomm\u00e9 par la cr\u00e9ation        : " + this.tempsConsommeCreation + " ms.");
            System.out.println("Temps de r\u00e9cup\u00e9ration des infos pour la cr\u00e9ation : " + this.tempsRecupInfosCreation + " ms.");
            for (ParagrapheNavig paragrapheNavig : this.paragraphesEnCreation) {
                HistoireMondiale.instance().gestEvenements().declarerCapturesEvenementsParagrapheHtml(paragrapheNavig);
            }
            this.paragraphes = this.paragraphesEnCreation;
            this.p_paragraphes.removeAll();
            this.ajusterTailleParagraphes();
            this.ajouterParagraphes();
        }
    }

    private void ajouterParagraphes() {
        for (ParagrapheNavig paragrapheNavig : this.paragraphes()) {
            this.p_paragraphes.add(paragrapheNavig);
        }
        BouchonParagraphesNavig bouchonParagraphesNavig = new BouchonParagraphesNavig();
        bouchonParagraphesNavig.setPreferredSize(new Dimension((int)this.p_paragraphes.getPreferredSize().getWidth(), 2000));
        int n = this.p_paragraphes.getComponentCount();
        bouchonParagraphesNavig.setBackground(n > 0 ? this.p_paragraphes.getComponent(n - 1).getBackground() : Color.WHITE);
        this.p_paragraphes.add(bouchonParagraphesNavig);
        this.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanNavigateur.this.appliquerDemandeAffParagrapheEnAttente();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JViewport jViewport = (JViewport)changeEvent.getSource();
        if ((double)jViewport.getWidth() != this.p_paragraphes.getPreferredSize().getWidth()) {
            Component component = this.p_paragraphes.getComponentAt(this.vuedefil_paragraphes.getViewport().getViewPosition());
            if (component instanceof ParagrapheNavig) {
                Point point = this.vuedefil_paragraphes.getViewport().getViewPosition();
                this.parAfficheAvantRedim = (ParagrapheNavig)this.p_paragraphes.getComponentAt(point);
                int n = (int)point.getX() - this.parAfficheAvantRedim.getX();
                int n2 = (int)point.getY() - this.parAfficheAvantRedim.getY();
                this.posDansParAffiche = this.parAfficheAvantRedim.viewToModel(new Point(n, n2));
                this.cptRedim = 2;
            }
            this.ajusterTailleParagraphes();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.cptRedim > 0) {
            --this.cptRedim;
        }
        if (this.parAfficheAvantRedim != null && this.cptRedim == 0) {
            Point point;
            try {
                point = this.parAfficheAvantRedim.modelToView(this.posDansParAffiche).getLocation();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            Point point2 = new Point((int)point.getX() + this.parAfficheAvantRedim.getX(), (int)point.getY() + this.parAfficheAvantRedim.getY());
            this.vuedefil_paragraphes.getViewport().setViewPosition(point2);
            this.parAfficheAvantRedim = null;
            this.posDansParAffiche = -1;
        }
    }

    private void ajusterTailleParagraphes() {
        if (!this.paragraphes.isEmpty()) {
            int n = this.vuedefil_paragraphes.getViewport().getWidth();
            for (Component component : this.p_paragraphes.getComponents()) {
                JComponent jComponent;
                if (component instanceof ParagrapheNavig) {
                    jComponent = (ParagrapheNavig)component;
                    if (((ParagrapheNavig)jComponent).largeur() != null && ((ParagrapheNavig)jComponent).largeur().equals(n)) continue;
                    ((ParagrapheNavig)jComponent).modifLargeur(n);
                    continue;
                }
                if (component instanceof BouchonParagraphesNavig) {
                    jComponent = (BouchonParagraphesNavig)component;
                    if (((BouchonParagraphesNavig)jComponent).largeur() != null && ((BouchonParagraphesNavig)jComponent).largeur().equals(n)) continue;
                    ((BouchonParagraphesNavig)jComponent).modifLargeur(n);
                    continue;
                }
                throw new IllegalStateException("Redimensionnement - composant inconnu : " + component);
            }
        }
    }

    public void afficherParagraphe(InfosParagrapheNavig infosParagrapheNavig) {
        if (infosParagrapheNavig == null) {
            return;
        }
        this.demandeAffParagrapheEnAttente = infosParagrapheNavig;
        if (!this.paragraphes.isEmpty()) {
            this.appliquerDemandeAffParagrapheEnAttente();
        }
    }

    private void appliquerDemandeAffParagrapheEnAttente() {
        if (this.marqueurPremApplicationAffParagraphe) {
            this.marqueurPremApplicationAffParagraphe = false;
            this.marqueurDeuxApplicationAffParagraphe = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanNavigateur.this.appliquerDemandeAffParagrapheEnAttente();
                }
            });
            return;
        }
        if (this.marqueurDeuxApplicationAffParagraphe) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanNavigateur.this.appliquerDemandeAffParagrapheEnAttente();
                }
            });
            this.marqueurDeuxApplicationAffParagraphe = false;
            return;
        }
        if (this.demandeAffParagrapheEnAttente != null) {
            InfosParagrapheNavig infosParagrapheNavig = this.demandeAffParagrapheEnAttente;
            for (int i = 0; i < this.paragraphes.size(); ++i) {
                if (!this.paragraphes.get(i).paragraphe().equals(infosParagrapheNavig)) continue;
                Point point = ((ParagrapheNavig)this.p_paragraphes.getComponent(i)).getLocation();
                this.vuedefil_paragraphes.getViewport().setViewPosition(point);
                break;
            }
        }
    }

    private void centrerSurCivilisationSuivie() {
        DonneesIGraphique donneesIGraphique;
        InfosParagrapheNavig infosParagrapheNavig;
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        Civilisation civilisation = etatAppli.civilisationSuivie();
        if (civilisation != null && (infosParagrapheNavig = (donneesIGraphique = histoireMondiale.donneesIGraphique()).paragrapheParCriteres(civilisation, etatAppli.annee())) != null) {
            this.afficherParagraphe(infosParagrapheNavig);
        }
    }

    public void desactiverReactionChangementAnnee() {
        this.reactionChangementAnneeDesactivee = true;
    }

    public void reactiverReactionChangementAnnee() {
        this.reactionChangementAnneeDesactivee = false;
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (!this.reactionChangementAnneeDesactivee && ("annee".equals(string) || "civilisationSelectionnee".equals(string) || "suiviCivilisationSelectionnee".equals(string))) {
            this.centrerSurCivilisationSuivie();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

