/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique;

import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.igraphique.GenRenduCivilisation;
import fr.histoiremondiale.histoire.igraphique.GenRenduParagraphe;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsNavigateur;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.igraphique.donnees.comparateurs.ComparateurParagraphesParDate;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialCivilisations
extends JDialog
implements MouseListener,
ListSelectionListener {
    static final String TEXTE_AUCUN_PARAGRAPHE = "(aucun paragraphe pour cette civilisation)";
    static final Object OBJET_PARAGRAPHE_BIDON = null;
    private JList<Object> liste_civilisation;
    private JList<Object> liste_paragraphes;

    public DialCivilisations(JFrame jFrame) {
        super(jFrame, "Civilisations", false);
        List<Civilisation> list = HistoireMondiale.instance().donneesHisto().civilisationsTrieesParNom();
        this.liste_civilisation = new JList<Civilisation>(new Vector<Civilisation>(list));
        this.liste_civilisation.setCellRenderer(new GenRenduCivilisation());
        this.liste_civilisation.setSelectionMode(0);
        this.liste_civilisation.addListSelectionListener(this);
        this.liste_civilisation.addMouseListener(this);
        this.liste_paragraphes = new JList();
        this.liste_paragraphes.setCellRenderer(new GenRenduParagraphe());
        this.liste_paragraphes.setSelectionMode(0);
        this.liste_paragraphes.addListSelectionListener(this);
        this.liste_paragraphes.addMouseListener(this);
        this.remplirListeParagraphes(null);
        this.getContentPane().setLayout(new GridLayout(1, 2));
        this.getContentPane().add(new JScrollPane(this.liste_civilisation));
        this.getContentPane().add(new JScrollPane(this.liste_paragraphes));
        this.setDefaultCloseOperation(1);
        this.setSize(500, 500);
        Fenetres.centrer(this, (Frame)jFrame);
        Fenetres.ajouterEcouteurEchapPourMasquer(this);
    }

    private void remplirListeParagraphes(Civilisation civilisation) {
        List<InfosParagrapheNavig> list;
        Vector<Object> vector = null;
        if (civilisation != null && !(list = HistoireMondiale.instance().donneesIGraphique().paragraphesParCriteres(civilisation, null)).isEmpty()) {
            Collections.sort(list, new ComparateurParagraphesParDate());
            vector = new Vector<InfosParagrapheNavig>(list);
        }
        if (vector == null) {
            vector = new Vector<Object>();
            vector.add(OBJET_PARAGRAPHE_BIDON);
        }
        this.liste_paragraphes.setListData(vector);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.liste_civilisation) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Civilisation civilisation = (Civilisation)this.liste_civilisation.getSelectedValue();
                this.remplirListeParagraphes(civilisation);
                ActionsOptionsGraphiques.modifierCivilisationSelectionnee(civilisation);
            }
        } else if (object == this.liste_paragraphes) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                InfosParagrapheNavig infosParagrapheNavig = (InfosParagrapheNavig)this.liste_paragraphes.getSelectedValue();
                if (infosParagrapheNavig == OBJET_PARAGRAPHE_BIDON) {
                    this.liste_paragraphes.clearSelection();
                } else {
                    ActionsNavigateur.affVueCorrespondante(infosParagrapheNavig);
                }
            }
        } else {
            throw new IllegalStateException("Source inconnue");
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        EtatAppli etatAppli = HistoireMondiale.instance().etat();
        Object object = mouseEvent.getSource();
        if (object == this.liste_civilisation) {
            if (mouseEvent.getClickCount() == 2) {
                int n = this.liste_civilisation.locationToIndex(mouseEvent.getPoint());
                Civilisation civilisation = (Civilisation)this.liste_civilisation.getModel().getElementAt(n);
                ActionsCarte.centrerCarteSurCivilisation(civilisation, etatAppli.annee());
                ActionsOptionsGraphiques.modifierCivilisationSelectionnee(civilisation);
            }
        } else if (object == this.liste_paragraphes) {
            if (etatAppli.simpleClicFermerParagraphes() && mouseEvent.getClickCount() == 1 || !etatAppli.simpleClicFermerParagraphes() && mouseEvent.getClickCount() == 2) {
                this.setVisible(false);
            }
        } else {
            throw new IllegalStateException("Source inconnue");
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

