/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.verificationdonnees;

import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Messages;

public class VerificateurParagraphes
{
	public void verifierParagraphes()
	{
		HistoireMondiale application = HistoireMondiale.instance();
		StringBuffer sb0 = new StringBuffer();
		StringBuffer sb1 = new StringBuffer();
		StringBuffer sb2 = new StringBuffer();
		//le nombre de problèmes
		int nbPb0 = 0, nbPb1 = 0, nbPb2 = 0;
        // Charger les données de l'appli
       for(Territoire t : application.donneesHisto().territoires())
       {
//    	   System.out.println(t.nomNormalise());
    	   Civilisation civ = t.civilisation();
			if (civ == null)
			{
				sb0.append("le territoire " + t.enChaine() + " n'a pas de civilisation rattachée\n");
				nbPb0++;
			}
			else
			{
				int debut = t.dateDebut();
				int fin = t.dateFin();
				for (int annee = debut; annee < fin; annee++)
				{
					if (annee == 0)
					{
						annee++;
					}
					InfosParagrapheNavig p = application.donneesIGraphique().paragrapheParCriteres(civ, annee);
					if (p == null)
					{
						sb1.append("le territoire " + t.enChaine() + " n'a pas de paragraphe rattaché pour l'année " + annee + "\n");
						nbPb1++;
						break;
					}
					else
					{
						String titre = p.titre();
						if (titre.isEmpty())
						{
							sb2.append("le territoire " + t.enChaine() + " est rattaché à un paragraphe à construire pour l'année " + annee + "\n");
							nbPb2++;
							break;
						}
					}
				}

			}
		}
		//sb.append("il ya " + nbPb + " sur les paragraphes.");
		Messages.messageInfo("il ya " + nbPb0 + " paragraphes sans civilisations (voir la console)");
		System.out.println("***************************************");
		System.out.println(sb0.toString());
		Messages.messageInfo("il ya " + nbPb1 + " territoires sans paragraphes (voir la console)");
		System.out.println("***************************************");
		System.out.println(sb1.toString());
		Messages.messageInfo("il ya " + nbPb2 + " territoires rattachés à un paragraphes à construire (voir la console)");
		System.out.println("***************************************");
		System.out.println(sb2.toString());
		
	}
	
	public static void main(String[] args)
	{
		VerificateurParagraphes vp = new VerificateurParagraphes();
		vp.verifierParagraphes();
		
	}
}
