/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.verificationdonnees;

import static fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique.ENCODAGE_PAGES_HTML;
import static fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique.NOM_FIC_DEBUT_HTML;
import static fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique.NOM_FIC_FIN_HTML;
import static fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique.NOM_REP_DONNEES_PARAGRAPHES;
import static fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique.PREFIXE_NOM_FIC_PARAGRAPHES;
import static fr.histoiremondiale.histoire.utiles.es.fichiers.Fichiers.chargerContenuTexte;

import java.io.File ;
import java.io.FileOutputStream ;
import java.io.IOException ;
import java.io.OutputStreamWriter ;
import java.io.PrintWriter ;
import java.util.ArrayList ;
import java.util.Collections ;
import java.util.List ;



/**
 * Assemble les paragraphes en une seule page html, qui peut être vérifiée par un validateur html.
 */
public class AssembleurPageParagraphes
{

    /**
     * Assemble les paragraphes en une page html.
     * @param chemFicRes Chemin du fichier dans lequel écrire le résultat.
     * @throws IOException En cas de problème d'entrée/sortie.
     */
    public void assemblerPage (String chemFicRes) throws IOException
    {
        String chemRepParagraphes = "donnees" + File.separator + NOM_REP_DONNEES_PARAGRAPHES + File.separator ;
        File   repParagraphes     = new File (chemRepParagraphes) ;
        File   ficPageRes         = new File (chemFicRes) ;
        String debPage            = chargerContenuTexte (chemRepParagraphes + NOM_FIC_DEBUT_HTML, ENCODAGE_PAGES_HTML) ;
        String finPage            = chargerContenuTexte (chemRepParagraphes + NOM_FIC_FIN_HTML,   ENCODAGE_PAGES_HTML) ;


        // Créer la page de destination
        PrintWriter ecr = new PrintWriter (new OutputStreamWriter (new FileOutputStream (ficPageRes), ENCODAGE_PAGES_HTML)) ;
        ecr.println (debPage) ;
        
        // Lister les fichiers des paragraphes
        List<String> chemFicsParagraphes = new ArrayList<>() ;
        for (File fic : repParagraphes.listFiles())
        {
            if (fic.getName().startsWith (PREFIXE_NOM_FIC_PARAGRAPHES))
                chemFicsParagraphes.add (fic.getAbsolutePath()) ;
        }
        Collections.sort (chemFicsParagraphes) ;
        
        // Ajouter tous les paragraphes
        for (String chemFicParagraphe : chemFicsParagraphes)
            ecr.println (chargerContenuTexte (chemFicParagraphe, ENCODAGE_PAGES_HTML)) ;
        
        // Terminer la construction de la page
        ecr.println (finPage) ;
        ecr.close() ;
    }
    
    
    
    // Méthode principale
    public static void main (String[] args) throws Exception
    {
        new AssembleurPageParagraphes().assemblerPage ("/tmp/page-paragraphes.html") ;
    }
    
}
