/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.GestEvenementsGenerique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt;



/**
 * Détecte les mouvements de souris au-dessus un composant donné et en informe le gestionnaire d'événements.
 */
public class EcouteurMouvementSouris implements MouseMotionListener
{
    
    private Component      composant ;      // Composant écouté
    private GestEvenementsGenerique gestEvts ;       // Gestionnaire d'événements à contacter

    
    
    /**
     * Constructeur.
     * @param composant Le composant écouté.
     * @param gestEvenementsGeneriques  Gestionnaire d'événements à contacter.
     */
    public EcouteurMouvementSouris (Component composant, GestEvenementsGenerique gestEvenementsGeneriques)
    {
        this.composant = composant ;
        this.gestEvts  = gestEvenementsGeneriques ;
    }

    
    
    // Interception de l'événement
    public void mouseMoved (MouseEvent evt)
    {
        this.gestEvts.traiterEvenement (new Evenement (this.composant, TypeEvt.MOUVEMENT_SOURIS, evt)) ;
    }
    

    
    // Méthodes inutilisées
    public void mouseDragged (MouseEvent evt) {}

}
