/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing;

import java.awt.Color ;
import java.awt.Cursor ;
import java.awt.Font ;

import javax.swing.JLabel ;
import javax.swing.JPanel;
import javax.swing.JTextArea ;
import javax.swing.JTextField ;



/**
 * Fonctions utilitaires pour la création de composants texte.
 */
public class Textes
{
    
    public static final Font FONTE_SIMPLE   = new JLabel().getFont().deriveFont (0) ;
    public static final Font FONTE_GRASSE   = new JLabel().getFont().deriveFont (Font.BOLD) ;
    public static final Font FONTE_ITALIQUE = new JLabel().getFont().deriveFont (Font.ITALIC) ;

    private static final Color COULEUR_FOND = new JPanel().getBackground();

    
    /**
     * Crée un texte de police donnée.<br>
     * (JLabel ne permet pas de sélectionner le texte)<br>
     * (JTexteArea est plus souple que JTexteField : on peut avoir du texte sur plusieurs lignes)
     * @param fonte Police de caractère à utiliser.
     * @param texte Texte à écrire sur le composant.
     * @return Un objet permettant d'afficher ce texte.
     */
    public static JTextArea texte (Font fonte, String texte)
    {
        // Créer l'objet
        JTextArea txt = new JTextArea (texte) ;
        txt.setFont     (fonte) ;
        txt.setEditable (false) ;
        txt.setBorder   (null) ;
        txt.setBackground (COULEUR_FOND) ;

        // Renvoyer l'objet créé
        return txt ;
    }
    
    /**
     * Crée un lien vers un site web.<br>
     * (JLabel ne permet pas de sélectionner le texte)
     * @param fonte Police de caractère à utiliser.
     * @param texte Texte à écrire sur le composant.
     * @param url   Adresse à faire afficher par le navigateur quand l'utilisateur clique sur le lien.
     * @return Un objet permettant d'afficher ce texte.
     */
    public static JTextField lien (Font fonte, String texte, String url)
    {
        // Créer l'objet
        JTextField txt = new JTextField (texte) ;
        txt.setFont       (fonte) ;
        txt.setForeground (Color.BLUE) ;
        
        
        // Ajouter un écouteur pour gérer le clic sur le lien
        // (toujours ajouter l'écouteur, ça évite que les clics remontent aux composants parents et que
        //  le comportement change suivant si le lien est cliquable ou non)
        txt.addMouseListener (new EcouteurLienHttp (url)) ;
        if (EcouteurLienHttp.navigateurDisponible())
            txt.setCursor (Cursor.getPredefinedCursor (Cursor.HAND_CURSOR)) ;
        txt.setEditable (false) ;
        txt.setBorder   (null) ;
        
        // Renvoyer l'objet
        return txt ;
    }
}
