/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing;

import java.awt.Desktop ;
import java.awt.event.MouseEvent ;
import java.awt.event.MouseListener ;
import java.net.URI ;



/**
 * Classe permettant d'ajouter un écouteur d'événement sur un composant. Quand l'utilisateur clique sur
 *   le composant, le navigateur web par défaut du système est ouvert sur la page choisie.
 */
public class EcouteurLienHttp implements MouseListener
{

    private String url ;        // URL de la page à afficher
    
    
    
    /**
     * Constructeur.
     * @param url L'URL à fournir au navigateur.
     */
    public EcouteurLienHttp (String url)
    {
        this.url = url ;
    }



    /**
     * Affiche la page désignée par l'URL dans le navigateur web par défaut du système.
     * @param evt L'événement déclencheur.
     */
    public void mousePressed (MouseEvent evt)
    {
        // Afficher la page si un navigateur est disponible
        if (navigateurDisponible())
        {
            try
            {
                Desktop.getDesktop().browse (new URI (this.url)) ;
            }
            catch (Exception e)
            {
                e.printStackTrace() ;
                System.err.println ("Exception : " + e.getMessage()) ;
            }
        }
        else
        {
            System.err.println ("Impossible de récupérer le navigateur web par défaut.") ;
        }
    }
    
    
    
    /**
     * Indique si on est en mesure d'afficher une page web dans un navigateur.
     * @return Vrai si la nevigateur est disponible, faux sinon.
     */
    public static boolean navigateurDisponible ()
    {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported (Desktop.Action.BROWSE) ;
    }

    
    
    // Méthodes non implémentées
    public void mouseClicked  (MouseEvent evt) {} ;
    public void mouseEntered  (MouseEvent evt) {} ;
    public void mouseExited   (MouseEvent evt) {} ;
    public void mouseReleased (MouseEvent evt) {} ;
    
}
