/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing;

import java.awt.event.MouseEvent ;
import java.awt.event.MouseListener ;
import java.util.List ;

import javax.swing.JComponent ;
import javax.swing.JDialog ;



/**
 * Classe permettant d'afficher une boîte de dialogue d'infos quand on clique sur un composant.
 */
public class EcouteurDialInfos implements MouseListener
{

    private JDialog          parent ;
    private List<JComponent> composants ;
    private DialInfos        dialogue ;
    
    
    
    /**
     * Constructeur.
     * @param parent     La boîte mère.
     * @param composants Les composants à placer dans la boîte.
     */
    public EcouteurDialInfos (JDialog parent, List<JComponent> composants)
    {
        this.parent     = parent ;
        this.composants = composants ;
    }
    
    
    /**
     * Affiche la boîte de dialogue centrée sur le point auquel est situé l'événement.
     * @param evt L'événement déclencheur.
     */
    public void mousePressed (MouseEvent evt)
    {
        // S'assurer que la boîte de dialogue est bien construite
        if (this.dialogue == null)
            this.dialogue = new DialInfos (this.parent, this.composants) ;
        
        // Afficher la boîte de dialogue au bon endroit
        this.dialogue.afficher ((int)evt.getLocationOnScreen().getX(), (int)evt.getLocationOnScreen().getY()) ;
    }
    
    
    
    // Méthodes non implémentées
    public void mouseClicked  (MouseEvent evt) {} ;
    public void mouseEntered  (MouseEvent evt) {} ;
    public void mouseExited   (MouseEvent evt) {} ;
    public void mouseReleased (MouseEvent evt) {} ;
    
}
