/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.dessin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;



/**
 * Fonctions utiles pour la manipulation d'images.
 */
public class Images
{

    /**
     * Renvoie une copie de l'image en paramètre en redessinant l'ancienne sur la nouvelle.
     * @param imageSource          Image à copier.
     * @param composantObservateur Un composant graphique.
     * @return                     Une nouvelle image, copie de celle en paramètre.
     */
    public static BufferedImage copie (BufferedImage imageSource, ImageObserver composantObservateur)
    {
        // Note : cette méthode est sans doute un peu étrange (par rapport à copier les données de l'image
        //        source dans l'image destination) mais devrait marcher dans tous les cas, même avec de
        //        la transparence, ....
        
        // Créer la nouvelle image
        BufferedImage imageDest = new BufferedImage (imageSource.getWidth(),
                                                     imageSource.getHeight(),
                                                     BufferedImage.TYPE_INT_ARGB) ;
        
        // Copier l'image
        Graphics g = imageDest.getGraphics() ;
        g.drawImage (imageSource, 0, 0, composantObservateur) ;
        g.dispose() ;
            
        // Renvoyer l'image
        return imageDest ;
    }

    /**
     * renvoie l'image contenues dans le fichier
     * @param fichier le fichier
     * @return l'image
     */
    public static BufferedImage charger(File fichier)
    {
    	BufferedImage image;
    	
    	try 
    	{
			image = ImageIO.read(fichier);
		} 
    	catch (IOException e) 
    	{
			throw new RuntimeException ("Erreur lors du chargement de l'image", e) ;		
		}
    	return image;
    }
    
    /**
     * renvoie le composant sous forme d'une image
     * @param composant le composant dont on veut le dessin
     * @return l'image correspondante
     */
    public static BufferedImage getImage(Component composant)
    {
    	if(composant==null){return null;}
    	int width = composant.getWidth();
    	int height = composant.getHeight();
    	BufferedImage image = new BufferedImage(width, height, 
    	                                             BufferedImage.TYPE_INT_RGB);
    	Graphics2D g = image.createGraphics();
    	composant.paintAll(g);
    	g.dispose();
    	return image;    
    }

}
