/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.exttypes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;



/**
 * Utilitaires pour l'introspection.
 */
public class Objets
{
    
    /**
     * Accès à l'attribut de l'objet dont le nom est passé en paramètre.<br>
     * La méthode tente d'utiliser un accesseur du même nom que l'attribut.<br>
     * Si elle n'en trouve pas, elle tente d'accéder directement à l'attribut.<br>
     * Lève une exception non déclarée si l'attribut n'est pas trouvé.
     * @param objet       L'objet considéré.
     * @param nomAttribut Le nom de l'attribut à lire.
     * @return La valeur de l'attribut de l'objet.
     */
    public static Object valAttribut (Object objet, String nomAttribut)
    {
        try
        {
           // Essayer avec un accesseur
            Method accesseur = objet.getClass().getMethod (nomAttribut) ;
            if (accesseur != null)
            {
                accesseur.setAccessible (true) ;
                return accesseur.invoke (objet) ;
            }
            // Sinon lire directement l'attribut
            else
            {
                Field attribut = objet.getClass().getDeclaredField (nomAttribut) ;
                attribut.setAccessible (true) ;
                return attribut.get (objet) ;
            }
        }
        catch (Exception e)
        {
            throw new RuntimeException ("Erreur lors de l'accès à l'attribut \"" + nomAttribut + "\"", e) ;
        }
    }
}
