/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import java.util.Observable ;
import java.util.Observer ;

import javax.swing.JLabel ;

import fr.histoiremondiale.histoire.utiles.exttypes.Flottants;
import fr.histoiremondiale.histoire.utiles.exttypes.Objets;



/**
 * Représente un texte affiché à l'écran.<br>
 * Le texte est liée à l'état de l'application et modifie son état en fonction de celui de l'appli.<br>
 * Un modèle sert au composant à afficher son texte. Voir les constantes.
 */
public class Texte extends JLabel implements Observer
{

    // Constantes
    public static final String MARQUEUR_REMPL_VAL_CHAINE   = "##valCh##" ;      // A remplacer par ""+valAttribut
    public static final String MARQUEUR_REMPL_VAL_FLOTTANT = "##valFS##" ;      // A remplacer par une valeur flottante correctement formatée
    
    
    // Données
    private String modeleTexte ;    // Texte affiché par le composant. Des éléments sont remplacés lors de l'affichage.
    private Object objetObserve ;   // Objet contenant l'attribut observé
    private String nomAttribut ;    // Nom de l'attribut que représente le texte

    
    
    /**
     * Constructeur.
     * @param modeleTexte Modèle de texte à compléter pour l'affichage.
     * @param objetObserve Objet observé.
     * @param nomAttribut  Nom de l'attribut observé.
     */
    public Texte (String modeleTexte, Observable objetObserve, String nomAttribut)
    {
        // Inscrire l'objet comme observateur
        objetObserve.addObserver (this) ;
        
        // Mémoriser les paramètres
        this.modeleTexte  = modeleTexte ;
        this.objetObserve = objetObserve ;
        this.nomAttribut  = nomAttribut ;
        
        // Représenter l'élément
        ajusterRepresentation() ;
    }
    
    
    
    /**
     * Réception d'une notification de modification de l'état de l'application.
     */
    public void update (Observable observe, Object param)
    {
        String eltModifie = (String) param ;
        
        // Ajuster la représentation du texte s'il est concerné
        if (this.nomAttribut == null || this.nomAttribut.equals (eltModifie))
            ajusterRepresentation() ;
    }
    
    
    /**
     * Affiche le texte en fonction de la valeur de l'attribut qui lui est associé.
     */
    public void ajusterRepresentation ()
    {
        Object valAttribut = Objets.valAttribut (this.objetObserve, this.nomAttribut) ;
        this.setText (this.modeleTexte.replace (MARQUEUR_REMPL_VAL_CHAINE,   ""+valAttribut)
                                      .replace (MARQUEUR_REMPL_VAL_FLOTTANT, (valAttribut instanceof Double ? Flottants.formaterSimplifier ((Double)valAttribut) : "[erreur : pas un Double]"))) ;
    }


    
    // Accesseurs
    public Object objetObserve () { return this.objetObserve ; }
    public String nomAttribut  () { return this.nomAttribut ; }

}
