/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique;

import java.awt.BorderLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

import fr.histoiremondiale.histoire.igraphique.composants.BarreLoupe;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;


/**
 * Boîte de dialogue permettant de choisir la valeur de la loupe.
 */
public class DialLoupe extends JDialog //implements WindowListener
{
    public BarreLoupe barre ; // La barre
    private JPanel sud ; // le panneau en bas
    public JButton btnOK ; //le bouton OK
    public JButton btnAnnul ; // le bouton annul
    //private double valeurInitiale ;
    
    
    
    public double valeurInitiale()
	{
		return this.barre.reference();
	}

	/**
     * Constructeur.
     * @param parent Fenêtre parent.
     * @param titre  Titre de la boîte de dialogue.
     * @param mini   Valeur minimale.
     * @param maxi   Valeur maximale.
     */
    public DialLoupe (JFrame parent, String titre, double mini, double maxi)  
    {
        super(parent, titre, true) ;
        //this.valeurInitiale = 1.0 ; //peut-être inutile
        //La barre avec une valeur par défaut
        this.barre=new BarreLoupe(mini, maxi, 1.0);  // pour ne pas modifier le constructeur de la barre  
        setLayout (new BorderLayout() ) ;        
        add (this.barre,BorderLayout.CENTER);
        //this.barre.addChangeListener (this);
        //le panneau de bouton
        this.sud = new JPanel() ;
        this.btnOK = new JButton("OK") ;
        //this.btnOK.addActionListener (this) ;
        this.btnAnnul = new JButton("Annuler") ;
        //this.btnAnnul.addActionListener(this) ;
        this.sud.add (this.btnOK);
        this.sud.add(this.btnAnnul);
        add(this.sud, BorderLayout.SOUTH) ;
        //addWindowListener(this) ;
        
        this.pack () ;        
        
        Fenetres.centrer(this, parent);
        // Touches permettant de fermer la fenêtre
        Fenetres.ajouterEcouteurEchapPourMasquer (this) ;
        

        //this.setDefaultCloseOperation (DISPOSE_ON_CLOSE);
    }

    public void afficher(double valeur)
    {
    	//this.valeurInitiale = valeur;
    	this.barre.setValeur(valeur);
    	this.barre.setReference(valeur);
    	this.setVisible(true);
    }
}
