/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements;

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;

import fr.histoiremondiale.histoire.igraphique.composants.Barre;
import fr.histoiremondiale.histoire.igraphique.composants.BarreLoupe;
import fr.histoiremondiale.histoire.igraphique.composants.GlissiereDates;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurChangementEtat;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurChangementValeur;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicDroit;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicDroitMajuscule;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicGauche;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicGaucheEltMenu;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurFermetureDialogue;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurFermetureFenetre;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurGlissementSouris;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurMoletteSouris;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurMouvementSouris;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurPressionDroit;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurPressionGauche;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurRedimensionnement;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurSortieSouris;


public abstract class GestEvenementsGenerique
{

	/**
	 * Traite un évenement de l'application.
	 * 
	 * @param evt L'événement à traiter.
	 */
	public abstract void traiterEvenement(Evenement evt) ;

	
	// Méthodes permettant de déclarer l'interception de différents types d'événements
	protected void clicGauche(Component composant)
	{
		composant.addMouseListener(new EcouteurClicGauche(composant, this));
	}

	protected void clicDroit(Component composant)
	{
		composant.addMouseListener(new EcouteurClicDroit(composant, this));
	}

	protected void clicDroitMaj(Component composant)
	{
		composant.addMouseListener(new EcouteurClicDroitMajuscule(composant, this));
	}

	protected void pressionGauche(Component composant)
	{
		composant.addMouseListener(new EcouteurPressionGauche(composant, this));
	}

    protected void pressionDroit(Component composant)
    {
        composant.addMouseListener(new EcouteurPressionDroit(composant, this));
    }

	protected void moletteSouris(Component composant)
	{
		composant.addMouseWheelListener(new EcouteurMoletteSouris(composant, this));
	}

	protected void glissement(Component composant)
	{
		composant.addMouseMotionListener(new EcouteurGlissementSouris(composant, this));
	}

	protected void mouvement(Component composant)
	{
		composant.addMouseMotionListener(new EcouteurMouvementSouris(composant, this));
	}

	protected void sortie(Component composant)
	{
		composant.addMouseListener(new EcouteurSortieSouris(composant, this));
	}

	protected void fermetureFenetre(JFrame fenetre)
	{
		fenetre.addWindowListener(new EcouteurFermetureFenetre(fenetre, this));
	}
	
	protected void fermetureDialogue(JDialog dialogue)
	{
		dialogue.addWindowListener(new EcouteurFermetureDialogue(dialogue, this));
	}
	
	protected void changementValeur(JScrollBar composant)
	{
		composant.addAdjustmentListener(new EcouteurChangementValeur(composant, this));
	} // Rien de plus générique comme paramètre, mais on peut surcharger la méthode

	protected void changementEtat(GlissiereDates composant)
	{
		composant.addChangeListener(new EcouteurChangementEtat(composant, this));
	} // Rien de plus générique comme paramètre, mais on peut surcharger la méthode

	protected void changementEtat(BarreLoupe composant)
	{
		composant.addChangeListener(new EcouteurChangementEtat(composant,this));
	}//changement d'état sur une BarreLoupe
	
	protected void changementEtat(Barre composant) 
	{
		composant.addChangeListener(new EcouteurChangementEtat(composant,this));
	}//changement d'état sur une barre (longitude ou latitude)
	
	protected void redimensionnement(Component composant)
	{
		composant.addComponentListener(new EcouteurRedimensionnement(composant, this));
	}

	// Méthode permettant de déclarer l'interception des clics gauche sur les éléments
	// d'un menu
	protected void clicGaucheEltsMenu(JMenu menu)
	{
		for (int i = 0; i < menu.getItemCount(); i++)
		{
			JMenuItem eltMenu = menu.getItem(i);
			if (eltMenu != null)
			{
				eltMenu.addActionListener(new EcouteurClicGaucheEltMenu(menu, this));
			}
		}
	}

	protected void clicGaucheEltsMenu(JPopupMenu menu)
	{
		for (int i = 0; i < menu.getComponentCount(); i++)
		{
			JMenuItem eltMenu = (JMenuItem) menu.getComponent(i);
			if (eltMenu != null)
			{
				eltMenu.addActionListener(new EcouteurClicGaucheEltMenu(menu, this));
			}
		}
	}

	// Méthode permettant d'ajouter un raccourci clavier à l'élément de menu (le clic
	// gauche sur l'élément
	// doit avoir été déclaré, l'action déclenchée sera la même).
	// Le raccourci clavier est une chaîne telle que définie dans la classe KeyStroke.
	protected void raccourciClavierEltMenu(JMenuItem eltMenu, String raccourciClavier)
	{
		eltMenu.setAction(new ActionRaccourciClavierMenu(eltMenu, raccourciClavier));
	}
	
}

//Classe permettant de gérer les raccourcis clavier pour les éléments de menu
class ActionRaccourciClavierMenu extends AbstractAction
{

	// Constructeur
	public ActionRaccourciClavierMenu(JMenuItem eltMenu, String raccourciClavier)
	{
		super(eltMenu.getText());
		this.putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(raccourciClavier));
	}

	// Traitement des actions
	public void actionPerformed(ActionEvent e)
	{
		// (on ne fait rien : le simple fait que l'action soit définie fait que le
		// raccourci clavier déclenche
		// le même événement que si on avait cliqué sur l'élément de menu)
		// (pas réussi à ajouter ça simplement aux éléments de menu)
	}

}
