/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique;

import java.awt.Graphics2D ;



/**
 * Utilitaires pour la gestion des polices.
 */
public class Polices
{


    /**
     * Indique la largeur du texte écrit dans la police courante de l'outil de dessin.
     * @param texte Le texte considéré.
     * @param g     L'outil de dessin considéré.
     * @return La largeur du texte.
     */
    public static double largeur (String texte, Graphics2D g)
    {
        return g.getFont().getStringBounds(texte, g.getFontRenderContext()).getWidth() ;
    }
    
    
    /**
     * Indique la hauteur du texte écrit dans la police courante de l'outil de dessin.
     * @param texte Le texte considéré.
     * @param g     L'outil de dessin considéré.
     * @return La hauteur du texte.
     */
    public static double hauteur (String texte, Graphics2D g)
    {
        return g.getFont().getStringBounds(texte, g.getFontRenderContext()).getHeight() ;
    }
    
    
    /**
     * Indique de combien les caractères peuvent s'élever au-dessus de la ligne de base<br>
     * Note : D'après la doc, certains caractères peuvent quand même aller au-delà.
     * @param texte Le texte considéré.
     * @param g     L'outil de dessin considéré.
     * @return L'élévation du texte au-dessus de la ligne de base.
     */
    public static double elevation (String texte, Graphics2D g)
    {
        return g.getFont().getLineMetrics(texte, g.getFontRenderContext()).getAscent() ;
    }
    
    
}
