/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.exttypes;

import java.awt.Color;



/**
 * Fonctions utiles sur les couleurs.
 * Note : Une couleur est transparente quand sa valeur alpha est à 0 (et non à 255).
 */
public class Couleurs
{

    /**
     * Convertir un nombre représentant une couleur en objet couleur.<br>
     * La couleur est opaque.<br>
     * Format du nombre : 0BVR (un octet à 0, un octet bleu, un octet vert, un octet rouge)
     *   (0BVR : format des couleur VB).
     * @param nombre Une couleur au format 0BVR.
     * @return L'objet représentant la couleur.
     */
    public static Color BVREnCouleur (int nombre)
    {
        int bleu  = (nombre & 0xFF0000) >> 16 ;
        int vert  = (nombre & 0x00FF00) >>  8 ;
        int rouge = (nombre & 0x0000FF) ;
        return new Color (rouge, vert, bleu) ;
    }
    
}
