/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.stockage;

import java.awt.image.BufferedImage ;
import java.io.File ;
import java.io.IOException ;

import javax.imageio.ImageIO ;



/**
 * Outil permettant d'exporter une image au format PNG.
 */
public class ExporteurPNG
{

    /**
     * Stocke l'image en paramètre dans le fichier demandé, au format PNG.<br>
     * Attention : la méthode écrase le fichier s'il existe déjà, c'est à l'appelant d'effectuer les
     *   vérifications.
     * @param image       Image à exporter.
     * @param chemFicDest Chemin du fichier dans lequel exporter l'image.
     * @throws IOException En cas de problème d'accès aux données.
     */
    public void exporter (BufferedImage image, String chemFicDest) throws IOException
    {
        this.exporter (image, new File (chemFicDest)) ;
    }
    
    /**
     * Stocke l'image en paramètre dans le fichier demandé, au format PNG.<br>
     * Attention : la méthode écrase le fichier s'il existe déjà, c'est à l'appelant d'effectuer les
     *   vérifications.
     * @param image   Image à exporter.
     * @param ficDest Le fichier dans lequel exporter l'image.
     * @throws IOException En cas de problème d'accès aux données.
     */
    public void exporter (BufferedImage image, File ficDest) throws IOException
    {
        ImageIO.write (image, "PNG", ficDest) ;
    }
    
}
