/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * This file is part of Histoire.
 *
 * Histoire is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Histoire is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Histoire. If not, see <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import fr.histoiremondiale.histoire.utiles.math.CalculsPlan;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;

//import fr.histoiremondiale.histoire.utiles.math.CalculsPlan;
//import fr.histoiremondiale.histoire.utiles.math.PointPlan;


/**
 * Représente une entréeou une sortie du cercle, pour le dessin de la carte.
 */
public class EntreeSortie
{
        // Constantes
    private static PointPlan PT_CENTRE = new PointPlan (  0, 0) ;
    private static PointPlan PT_I      = new PointPlan (100, 0) ;
    public static final int ENTREE    = 0;
    public static final int SORTIE    = 1;
    
    // Données
    private PointPlan ptSurLeCercle ;       // Point sur le cercle, entrée ou sortie
    private int       index ;               // Indice du point dans la liste de points
    private double    angle ;               // Angle entre l'horizontale et le point (en radians)
    private int       type  ;               // entrée ou sortie
    
    
    
    /**
     * Constructeur.
     * @param type  Type de l'objet (entrée ou sortie).
     * @param point Point sur le cercle, entrée ou sortie.
     * @param index Indice du point dans la liste de points.
     */
    public EntreeSortie (int type, PointPlan point, int index)
    {
        this.ptSurLeCercle  = point ;
        this.index          = index ;
        this.angle          = CalculsPlan.angle (PT_CENTRE, PT_I, point) ;
        this.type           = type ;
    }
    
    // Renvoie une représentation de l'objet sous forme de chaîne.
    public String toString ()
    {
        return (this.type==ENTREE ? "Entrée " : "Sortie ") + this.index + " - " + this.ptSurLeCercle.toString () + " - " + Math.toDegrees (this.angle) ;
    }

    public PointPlan getPtSurLeCercle ()
    {
        return this.ptSurLeCercle ;
    }

    public int getIndex ()
    {
        return this.index ;
    }

    public double getAngle ()
    {
        return this.angle ;
    }

    public int getType ()
    {
        return this.type ;
    }

    public boolean isSortie ()
    {
        return (this.type == SORTIE) ;
    }
    
}
