/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 * 
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou le modifier sous les
 * termes de la licence Affero GPL publiée par la Fondation pour le logiciel libre (Free
 * Software Foundation), en choisissant la version 3 de cette licence ou n'importe quelle
 * version ultérieure, à votre convenance.
 * 
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE D'AUCUNE SORTE
 * : y compris d'être vendable ou de pouvoir servir un but donné. Voir le texte de la
 * licence AGPL pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire. Si ce n'est pas le
 * cas, regardez à cette adresse : <http://www.gnu.org/licenses/>.
 * 
 */
package fr.histoiremondiale.histoire.igraphique.evenements;

import static fr.histoiremondiale.histoire.igraphique.FenPrincipale.MULTIPLICATEUR_ESPACE;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.affDialVisibiliteTerritoireEn;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.affParagrapheTerritoireEn;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.ajusterInfobullesPanneau;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.centrerCarteSiNonTexteSur;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.centrerCarteSiOrigineTexteSur;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.definirTerritoireSurvole;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.deplacerTexteTerritoire;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.initierDeplacementTexteTerritoireEn;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.modifierTailleDispoPourCarte;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.reinitialiserInfobullesPanneau;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.reinitialiserTerritoireSurvole;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.sauvegarderCarte;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.sauvegarderCarteEtParagraphe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte.visualiserParagraphe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.affDialChoixCentre;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.affDialChoixLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.annulerChangementCentre;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.annulerChangementDate ;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.annulerChangementLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.augmenterLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.decalerLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.diminuerLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.modifierAnnee;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.modifierLatitude;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.modifierLongitude;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.modifierLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.validerChangementCentre;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.validerChangementDate ;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps.validerChangementLoupe;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres.affDialAPropos;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres.affDialChoixCivilisation;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres.affDialChoixDate;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres.affFenPresentation;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres.affMenuContextuelDeplAnnees;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres.affMenuContextuelDeplEspace;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsGeneralesAppli.revenirAuxValeursInitiales;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsGeneralesAppli.sauverEtatEtQuitter;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsNavigateur.affVueCorrespondante;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsNavigateur.modifierSuiviCivilisation;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsNavigateur.naviguer;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserAffParagraphesHtmlGeneres;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserFleuvesVisibles;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserInfobullesCarte;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserMeridiensParallelesVisibles;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserMoletteGlisseDeUn;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserSimpleClicFermerParagraphes;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserSymboleTracer;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.inverserTexteSurvolFondClair;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.modifierPasDeplAnnees;
import static fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques.modifierPasDeplEspace;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.CHANGEMENT_ETAT;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.CHANGEMENT_VALEUR;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.CLIC_DROIT;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.CLIC_DROIT_MAJUSCULE;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.CLIC_GAUCHE;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.FERMETURE_FENETRE;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.GLISSEMENT_SOURIS;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.MOLETTE_SOURIS;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.MOUVEMENT_SOURIS;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.PRESSION_DROIT;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.PRESSION_GAUCHE;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.REDIMENSIONNEMENT;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt.SORTIE_SOURIS;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;

import javax.swing.JScrollBar;

import fr.histoiremondiale.histoire.igraphique.DialAnnee ;
import fr.histoiremondiale.histoire.igraphique.DialCentre;
import fr.histoiremondiale.histoire.igraphique.DialLoupe;
import fr.histoiremondiale.histoire.igraphique.FenPrincipale;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.PanNavigateur;
import fr.histoiremondiale.histoire.igraphique.ParagrapheNavig;
import fr.histoiremondiale.histoire.igraphique.composants.ConteneurValeur;
import fr.histoiremondiale.histoire.igraphique.composants.GlissiereDates;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.GestEvenementsGenerique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicDroit;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicGauche;



/**
 * Gère les événements de l'interface graphique.
 */
public class GestEvenementsHistoireMondiale extends GestEvenementsGenerique
{

	private FenPrincipale fenPrincipale ;          // Fenêtres gérées
	private DialLoupe     dialLoupe ;
    private DialAnnee     dialAnnee ;
	private DialCentre    dialCentre;
	
	
	
	/**
	 * Déclare les événements à capturer dans la fenêtre principale.
	 * @param fenPrincipale La fenêtre principale de l'application.
	 */
	public void declarerCapturesEvenementsFenPrincipale(FenPrincipale fenPrincipale)
	{
	    this.fenPrincipale = fenPrincipale ;
	    
		// Loupe carte
	    pressionGauche (fenPrincipale.bt_loupe) ;
        pressionDroit  (fenPrincipale.bt_loupe) ;
		moletteSouris  (fenPrincipale.p_carte) ;

		// Textes d'information
		clicGauche (fenPrincipale.txt_loupe) ;
		clicGauche (fenPrincipale.txt_annee) ;
		clicGauche (fenPrincipale.txt_pointCentral);

		// Menus
		// clicGaucheEltsMenu (fenPrincipale.eltmenu_chxLoupe) ;
		clicGaucheEltsMenu      (fenPrincipale.menu_fichier) ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_ficReinitValeurs,               "control I") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_ficExporterCarte,               "F2") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_ficExporterCarteEtParagraphe,   "control S") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_ficVisualiserParagraphe,        "control O") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_ficQuitter,                     "control Q") ;
		clicGaucheEltsMenu      (fenPrincipale.menu_navigation) ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_navigChoisirCivilisation,       "control R") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_navigChoisirDate,               "control D") ;
        raccourciClavierEltMenu (fenPrincipale.eltmenu_navigChoisirCentre,             "control P") ;
		clicGaucheEltsMenu      (fenPrincipale.menu_affichage) ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_affFleuvesVisibles,             "control F") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_affMeridiensParallelesVisibles, "control M") ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_affChoixLoupe,                  "control L") ;
		clicGaucheEltsMenu      (fenPrincipale.menu_options) ;
		clicGaucheEltsMenu      (fenPrincipale.menu_aide) ;
		raccourciClavierEltMenu (fenPrincipale.eltmenu_aidePresentation,               "F1") ;
		clicGaucheEltsMenu      (fenPrincipale.menu_deplAnnees) ;
		clicGaucheEltsMenu      (fenPrincipale.menu_deplEspace) ;
		clicGaucheEltsMenu      (fenPrincipale.menu_parametres) ;
		// (menus contextuels)
		clicGaucheEltsMenu      (fenPrincipale.menuctx_deplAnnees) ;
		clicGaucheEltsMenu      (fenPrincipale.menuctx_deplEspace) ;

		// Carte
		pressionGauche    (fenPrincipale.p_carte) ;
		clicGauche        (fenPrincipale.p_carte) ;
		clicDroit         (fenPrincipale.p_carte) ;
		clicDroitMaj      (fenPrincipale.p_carte) ;
		glissement        (fenPrincipale.p_carte) ;
		mouvement         (fenPrincipale.p_carte) ;
		sortie            (fenPrincipale.p_carte) ;
		redimensionnement (fenPrincipale.p_carte) ;

		// Barres de défilement longitude et latitude
		changementValeur (fenPrincipale.defil_longitudes) ;
		changementValeur (fenPrincipale.defil_latitudes) ;
		clicDroit        (fenPrincipale.defil_longitudes) ;
		clicDroit        (fenPrincipale.defil_latitudes) ;

		// Glissière des dates
		changementEtat (fenPrincipale.defil_annees) ;
		clicDroit      (fenPrincipale.defil_annees) ;

		// Navigateur html
		clicGauche (fenPrincipale.p_navigateur.cc_suiviCivilisation) ;

		// Fenêtre
		fermetureFenetre (fenPrincipale) ;
	}

	/**
	 * Déclare les événements à capturer pour un paragraphe dans le navigateur html.
	 * @param navig Navigateur dans les paragraphes.
	 */
	public void declarerCapturesEvenementsParagrapheHtml(ParagrapheNavig navig)
	{
		navig.addMouseListener (new EcouteurClicGauche(navig, this)) ;
		navig.addMouseListener (new EcouteurClicDroit(navig, this)) ;
	}
	
	public void declarerCapturesEvenementsDialLoupe(DialLoupe dialogue)
	{
	    this.dialLoupe = dialogue ;
	    
		changementEtat    (dialogue.barre) ;
		clicGauche        (dialogue.btnOK) ;
		clicGauche        (dialogue.btnAnnul) ;
		fermetureDialogue (dialogue) ;
	}

    public void declarerCapturesEvenementsDialAnnee(DialAnnee dialogue)
    {
        this.dialAnnee = dialogue ;
        
        clicGauche        (dialogue.btnOK) ;
        clicGauche        (dialogue.btnAnnul) ;
        fermetureDialogue (dialogue) ;
    }

	/**
	 * Pour traiter le dialogue permettant de changer le centre de la même façon 
	 * que celui qui permet de changer la loupe, c'est à dire changement sur la carte
	 * des modifications du centre
	 */
	public void declarerCapturesEvenementsDialCentre(DialCentre dialogue)
	{
		this.dialCentre = dialogue;
		
		changementEtat	  (dialogue.barreLongitude);
		changementEtat	  (dialogue.barreLatitude);
		clicGauche 		  (dialogue.btnOK) ;
		clicGauche 		  (dialogue.btnAnnul) ;
		fermetureDialogue (dialogue) ;
	}


	/**
	 * Traite un évenement de l'application.
	 * @param evt L'événement à traiter.
	 */
	public void traiterEvenement(Evenement evt)
	{
		// Infos sur l'événement à traiter
		TypeEvt     typeEvt ;         // Type de l'événement
		Component   composant ;       // Composant source de l'événement
		Object      composantReel ;   // Composant source de l'événement complet (le composant à la source de l'événement complet)
		EventObject evtComplet ;      // Evénement Java
		
		// Données disponibles ou non selon le type de l'événement
		Object valeur ;               // Valeur éventuellement contenue dans la source de l'événement
		int    xEvt ;                 // Coordonnées de l'événement sur le composant source (pour les événements issus de la souris)
		int    yEvt ;

		// Extraire les données de l'événement
		typeEvt       = evt.typeEvt() ;
		composant     = evt.composant() ;
		composantReel = evt.evtComplet().getSource() ;
		evtComplet    = evt.evtComplet() ;
		valeur        = (evtComplet.getSource() instanceof ConteneurValeur ? ((ConteneurValeur) evtComplet.getSource()).valeur() : null) ;
		xEvt          = (evtComplet             instanceof MouseEvent      ? ((MouseEvent) evtComplet).getX() : -1) ;
		yEvt          = (evtComplet             instanceof MouseEvent      ? ((MouseEvent) evtComplet).getY() : -1) ;

		// Fenêtre principale
		if (this.fenPrincipale != null)
		{
            FenPrincipale fenPpale = this.fenPrincipale ;
            PanCarte      p_carte  = this.fenPrincipale.p_carte ;
            PanNavigateur p_navig  = this.fenPrincipale.p_navigateur ;

            // Loupe carte
    		if (typeEvt == PRESSION_GAUCHE      && composant     == fenPpale.bt_loupe)                               augmenterLoupe() ;
    		if (typeEvt == PRESSION_DROIT       && composant     == fenPpale.bt_loupe)                               diminuerLoupe() ;
    		if (typeEvt == MOLETTE_SOURIS       && composant     == fenPpale.p_carte)                                decalerLoupe (-((MouseWheelEvent) evtComplet).getWheelRotation()) ;
    
    		// Textes d'information
    		if (typeEvt == CLIC_GAUCHE          && composant     == fenPpale.txt_loupe)                              affDialChoixLoupe() ;
    		if (typeEvt == CLIC_GAUCHE          && composant     == fenPpale.txt_annee)                              affDialChoixDate() ;
    		if (typeEvt == CLIC_GAUCHE			&& composant 	 == fenPpale.txt_pointCentral)						 affDialChoixCentre();	
    
    		// Menus
    		// (fichier)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_ficReinitValeurs)               revenirAuxValeursInitiales() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_ficExporterCarte)               sauvegarderCarte() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_ficExporterCarteEtParagraphe)   sauvegarderCarteEtParagraphe() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_ficVisualiserParagraphe)        visualiserParagraphe() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_ficQuitter)                     sauverEtatEtQuitter() ;
    		// (choix)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_navigChoisirCivilisation)       affDialChoixCivilisation() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_navigChoisirDate)               affDialChoixDate() ;
            if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_navigChoisirCentre)             affDialChoixCentre() ;
    		// (options)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_affFleuvesVisibles)             inverserFleuvesVisibles() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_affMeridiensParallelesVisibles) inverserMeridiensParallelesVisibles() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_optInfobullesCarte)             inverserInfobullesCarte() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_optSymboleTracer)               inverserSymboleTracer() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_optTexteSurvolFondClair)        inverserTexteSurvolFondClair() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_optSimpleClicFermerParagraphes) inverserSimpleClicFermerParagraphes() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_optMoletteGlisseDeUn)           inverserMoletteGlisseDeUn() ;
            if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_optAffParagraphesHtmlGeneres)   inverserAffParagraphesHtmlGeneres() ;
    		// (loupe)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_affChoixLoupe)                  affDialChoixLoupe() ;
    		// (pas (incrément) de déplacement)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composant     == fenPpale.menu_deplAnnees)                        modifierPasDeplAnnees ((Integer) valeur) ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composant     == fenPpale.menu_deplEspace)                        modifierPasDeplEspace((Integer) valeur) ;
    		// (aide)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_aidePresentation)               affFenPresentation() ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composantReel == fenPpale.eltmenu_aideAPropos)                    affDialAPropos() ;
    		// (menus contextuels)
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composant     == fenPpale.menuctx_deplAnnees)                     modifierPasDeplAnnees ((Integer) valeur) ;
    		if (typeEvt == CLIC_GAUCHE_ELT_MENU && composant     == fenPpale.menuctx_deplEspace)                     modifierPasDeplEspace((Integer) valeur) ;
    
    		// Carte
    		if (typeEvt == PRESSION_GAUCHE      && composant     == p_carte)                                         reinitialiserTerritoireSurvole() ;
    		if (typeEvt == PRESSION_GAUCHE      && composant     == p_carte)                                         reinitialiserInfobullesPanneau() ;
    		if (typeEvt == PRESSION_GAUCHE      && composant     == p_carte)                                         centrerCarteSiNonTexteSur (xEvt, yEvt) ;
    		if (typeEvt == PRESSION_GAUCHE      && composant     == p_carte)                                         initierDeplacementTexteTerritoireEn (xEvt, yEvt) ;
    		if (typeEvt == CLIC_GAUCHE          && composant     == p_carte)                                         centrerCarteSiOrigineTexteSur (xEvt, yEvt) ;
    		if (typeEvt == CLIC_DROIT           && composant     == p_carte)                                         affParagrapheTerritoireEn (xEvt, yEvt) ;
    		if (typeEvt == CLIC_DROIT_MAJUSCULE && composant     == p_carte)                                         affDialVisibiliteTerritoireEn (xEvt, yEvt) ;
    		if (typeEvt == GLISSEMENT_SOURIS    && composant     == p_carte)                                         deplacerTexteTerritoire (xEvt, yEvt) ;
    		if (typeEvt == MOUVEMENT_SOURIS     && composant     == p_carte)                                         definirTerritoireSurvole (xEvt, yEvt) ;
    		if (typeEvt == MOUVEMENT_SOURIS     && composant     == p_carte)                                         ajusterInfobullesPanneau (xEvt, yEvt) ;
    		if (typeEvt == SORTIE_SOURIS        && composant     == p_carte)                                         reinitialiserTerritoireSurvole() ;
    		if (typeEvt == SORTIE_SOURIS        && composant     == p_carte)                                         reinitialiserInfobullesPanneau() ;
    		if (typeEvt == REDIMENSIONNEMENT    && composant     == p_carte)                                         modifierTailleDispoPourCarte() ;
    
    		// Barres de défilement longitude et latitude
    		if (typeEvt == CHANGEMENT_VALEUR    && composant     == fenPpale.defil_longitudes)                       modifierLongitude ( (double) ((JScrollBar) composant).getValue() / MULTIPLICATEUR_ESPACE) ;
    		if (typeEvt == CHANGEMENT_VALEUR    && composant     == fenPpale.defil_latitudes)                        modifierLatitude  (-(double) ((JScrollBar) composant).getValue() / MULTIPLICATEUR_ESPACE) ;
    		if (typeEvt == CLIC_DROIT           && composant     == fenPpale.defil_longitudes)                       affMenuContextuelDeplEspace (fenPpale.defil_longitudes, xEvt, yEvt) ;
    		if (typeEvt == CLIC_DROIT           && composant     == fenPpale.defil_latitudes)                        affMenuContextuelDeplEspace (fenPpale.defil_latitudes,  xEvt, yEvt) ;
    
    		// Glissière des dates
    		if (typeEvt == CHANGEMENT_ETAT      && composant     == fenPpale.defil_annees)                           modifierAnnee (((GlissiereDates) composant).getValeur()) ;
    		if (typeEvt == CLIC_DROIT           && composant     == fenPpale.defil_annees)                           affMenuContextuelDeplAnnees (fenPpale.defil_annees, xEvt, yEvt) ;
    
    		// Navigateurs html
    		if (typeEvt == CLIC_GAUCHE          && composant     == p_navig.cc_suiviCivilisation)                    modifierSuiviCivilisation ((Boolean) valeur) ;
    		// (paragraphes)
    		if (typeEvt == CLIC_GAUCHE          && composant instanceof ParagrapheNavig)                             naviguer              ((ParagrapheNavig) composant, new Point(xEvt, yEvt)) ;
    		if (typeEvt == CLIC_DROIT           && composant instanceof ParagrapheNavig)                             affVueCorrespondante (((ParagrapheNavig) composant).paragraphe()) ;
    
    		// Fenêtre
    		if (typeEvt == FERMETURE_FENETRE    && composant     == fenPpale)                                        sauverEtatEtQuitter() ;
		}

		// DialLoupe
		if (this.dialLoupe != null)
		{
		    DialLoupe dialogueLoupe = this.dialLoupe ;
		    
    		if (typeEvt == CHANGEMENT_ETAT      && composant     == dialogueLoupe.barre)                             modifierLoupe (dialogueLoupe.barre.getValeur()) ;
    		if (typeEvt == CLIC_GAUCHE          && composant     == dialogueLoupe.btnOK)                             validerChangementLoupe() ;
    		if (typeEvt == CLIC_GAUCHE          && composant     == dialogueLoupe.btnAnnul)                          annulerChangementLoupe() ;
    		if (typeEvt == FERMETURE_FENETRE    && composant     == dialogueLoupe)                                   annulerChangementLoupe() ;
		}
		
        // DialLoupe
        if (this.dialAnnee != null)
        {
            DialAnnee dialogueAnnee = this.dialAnnee ;
            
            if (typeEvt == CLIC_GAUCHE          && composant     == dialogueAnnee.btnOK)                             validerChangementDate() ;
            if (typeEvt == CLIC_GAUCHE          && composant     == dialogueAnnee.btnAnnul)                          annulerChangementDate() ;
            if (typeEvt == FERMETURE_FENETRE    && composant     == dialogueAnnee)                                   annulerChangementDate() ;
        }
        
		//DialCentre
		if (this.dialCentre != null)
		{
		    DialCentre dialogueCentre = this.dialCentre ;
    		if (typeEvt == CHANGEMENT_ETAT      && composant     == dialogueCentre.barreLongitude)					 dialogueCentre.modifierLongitude();
    		if (typeEvt == CHANGEMENT_ETAT		&& composant	 == dialogueCentre.barreLatitude)					 dialogueCentre.modifierLatitude () ;
    		if (typeEvt == CLIC_GAUCHE          && composant     == dialogueCentre.btnOK)                            validerChangementCentre() ;
    		if (typeEvt == CLIC_GAUCHE          && composant     == dialogueCentre.btnAnnul)                         annulerChangementCentre() ;
    		if (typeEvt == FERMETURE_FENETRE    && composant     == dialogueCentre)                                  annulerChangementCentre() ;
		}
	}



	
}
