/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.donnees.comparateurs;

import java.util.Comparator ;

import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;



/**
 * Compare des paragraphes sur leurs date de début, puis sur leur date de fin.<br>
 * En cas d'égalité, les paragraphes sont classés par civilisation, pour avoir un ordre strict.
 */
public class ComparateurParagraphesParDate implements Comparator<InfosParagrapheNavig>
{
    
    // Comparaison
    public int compare (InfosParagrapheNavig paragraphe1, InfosParagrapheNavig paragraphe2)
    {
        // (début paragraphe)
        if (paragraphe1.anneeDeb() != paragraphe2.anneeDeb())
            return paragraphe1.anneeDeb() - paragraphe2.anneeDeb() ;
        // (fin paragraphe)
        if (paragraphe1.anneeFin() != paragraphe2.anneeFin())
            return paragraphe1.anneeFin() - paragraphe2.anneeFin() ;
        // (nom civilisation)
        if (paragraphe1.civilisation() != null && paragraphe2.civilisation() != null && ! paragraphe1.civilisation().equals (paragraphe2.civilisation()))
            return paragraphe1.civilisation().nom().compareTo (paragraphe2.civilisation().nom()) ;
        // (id paragraphe)
        return paragraphe1.id() - paragraphe2.id() ;
    }
    
}
