/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.actions;

import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Civilisation;



/**
 * Actions sur les options d'affichage, des composants graphiques, ...
 */
public class ActionsOptionsGraphiques
{

    /**
     * Inverse la valeur de l'option "fleuves visibles".
     */
    public static void inverserFleuvesVisibles ()
    {
        HistoireMondiale.instance().etat().inverserFleuvesAffiches() ;
    }
    
    
    /**
     * Inverse la valeur de l'option "méridiens et parallèles visibles".
     */
    public static void inverserMeridiensParallelesVisibles ()
    {
        HistoireMondiale.instance().etat().inverserMeridiensParallelesAffiches() ;
    }

    
    /**
     * Inverse la valeur de l'option "infobulles carte".
     */
    public static void inverserInfobullesCarte ()
    {
        HistoireMondiale.instance().etat().inverserInfobullesCarte() ;
    }
    
    
    /**
     * Inverse la valeur de l'option "symbole attente tracer".
     */
    public static void inverserSymboleTracer ()
    {
        HistoireMondiale.instance().etat().inverserSymboleAttenteTracer() ;
    }
    
    
    /**
     * Inverse la valeur de l'option "texte du territoire survolé sur fond clair".
     */
    public static void inverserTexteSurvolFondClair ()
    {
        HistoireMondiale.instance().etat().inverserTexteSurvolFondClair() ;
    }
    
    
    /**
     * Modifie le pas de déplacement des années
     * @param nouvIDeplAnnees Nouvelle valeur pour le pas de déplacement.
     */
    public static void modifierPasDeplAnnees (int nouvIDeplAnnees)
    {
        HistoireMondiale.instance().etat().modifIDeplAnnees (nouvIDeplAnnees) ;
    }
    
    
    /**
     * Modifie le pas de déplacement dans l'espace.
     * @param nouvIDeplEspace Nouvelle valeur pour le pas de déplacement.
     */
    public static void modifierPasDeplEspace (int nouvIDeplEspace)
    {
        HistoireMondiale.instance().etat().modifIDeplEspace (nouvIDeplEspace) ;
    }
    
    
    /**
     * Inverse la valeur de l'option "un simple clic ferme le dialogue de choix d'un paragraphe".
     */
    public static void inverserSimpleClicFermerParagraphes ()
    {
        HistoireMondiale.instance().etat().inverserSimpleClicFermerParagraphes() ;
    }
    
    
    /**
     * Inverse la valeur de l'option "la molette déplace les glissières de 1".
     */
    public static void inverserMoletteGlisseDeUn ()
    {
        HistoireMondiale.instance().etat().inverserMoletteGlisseDeUn() ;
    }
    
    
    /**
     * Inverse la valeur de l'option "les pages html générées sont affichées dans une fenêtre".
     */
    public static void inverserAffParagraphesHtmlGeneres ()
    {
        HistoireMondiale.instance().etat().inverserAffParagraphesHtmlGeneres() ;
    }
    
    
    /**
     * Modifie la civilisation sélectionnée.
     * @param nouvCivilisation Nouvelle civilisation sélectionnée.
     */
    public static void modifierCivilisationSelectionnee (Civilisation nouvCivilisation)
    {
        HistoireMondiale.instance().etat().modifCivilisationSelectionnee (nouvCivilisation) ;
    }
    
}
