/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique;

import java.awt.BorderLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import fr.histoiremondiale.histoire.igraphique.composants.TextFieldNumerique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;



public class DialAnnee extends JDialog
{
	private int annee, anneeInitiale;
    public JButton btnOK ; //le bouton OK
    public JButton btnAnnul ; // le bouton annul
	public TextFieldNumerique tfn;
	
	public DialAnnee(JFrame parent) 
	{
		super(parent, "Choix de la date", true);
		initComponent();
		pack();
		Fenetres.centrer(this, parent);
		Fenetres.ajouterEcouteurEchapPourMasquer(this);
	}

	private void initComponent() 
	{
		JPanel contenant = new JPanel();
		contenant.setLayout(new BorderLayout(5, 5));
		
		JPanel panelMessage = new JPanel();
		JLabel lbl = new JLabel("Saisissez une date (non nulle) entre -3100 et 2000");
		panelMessage.add(lbl);
		
		JPanel panelInput = new JPanel();
		tfn = new TextFieldNumerique(annee, true);
		tfn.addValeursAutorisees(-3100,-1);
		tfn.addValeursAutorisees(1,2000);
		tfn.setColumns(5);
		panelInput.add(tfn);
		
		JPanel controle = new JPanel();
		btnOK = new JButton("Valider");
		getRootPane().setDefaultButton(btnOK);
		
		btnAnnul = new JButton("Annuler");
		controle.add(btnOK);
		controle.add(btnAnnul);

		contenant.add(panelMessage, BorderLayout.NORTH);
		contenant.add(panelInput, BorderLayout.CENTER);
		contenant.add(controle, BorderLayout.SOUTH);
		
		getContentPane().add(contenant);	}

	public void showChoixAnnee (int annee)
	{
        this.annee         = annee;
        this.anneeInitiale = annee;

        tfn.setValue (annee) ;
        
		setVisible(true);
	}
	
	// Renvoie l'année choisie
	public int annee ()
	{
	    return Integer.parseInt(tfn.getText());
	}
	

}
