/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.donnees;



/**
 * Texte associé à un territoire pendant une période donnée.
 */
public class TexteTerritoire
{

    private int     anneeDeb ;
    private int     anneeFin ;
    private String  texte ;
    private boolean italique ;
     
    
    /**
     * Constructeur.
     * @param anneeDeb Début de la période pendant laquelle le texte est affiché.
     * @param anneeFin Fin   de la période pendant laquelle le texte est affiché.
     * @param texte    Texte à afficher.
     * @param italique Indique si le texte doit être affiché en italique ou non.
     */
    public TexteTerritoire (int anneeDeb, int anneeFin, String texte, boolean italique)
    {
        this.anneeDeb = anneeDeb ;
        this.anneeFin = anneeFin ;
        this.texte    = texte ;
        this.italique = italique ;
    }
    
    
    
    /**
     * Indique si le texte est affiché pendant l'année en paramètre.
     * @param annee L'année considérée.
     * @return vrai si le texte doit être affiché pour l'année indiquée, faux sinon.
     */
    public boolean afficheEn (int annee)
    {
        return this.anneeDeb <= annee && annee <= this.anneeFin ;
    }


    // Accesseurs
    public int     anneeDeb () { return this.anneeDeb ; }
    public int     anneeFin () { return this.anneeFin ; }
    public String  texte    () { return this.texte ; }
    public boolean italique () { return this.italique ; }

}
