/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.donnees;



/**
 * Représente une mer intérieure ou un grand lac.
 */
public class Mer implements RegionGeographique
{

    private Integer  id ;
    private String   nom ;
    private Pourtour pourtour ;
    
    
    
    /**
     * Constructeur.
     * @param id       L'identifiant de la mer.
     * @param nom      Le nom de la mer.
     * @param pourtour Le pourtour de la mer.
     */
    public Mer (Integer id, String nom, Pourtour pourtour)
    {
        this.id       = id ;
        this.nom      = nom ;
        this.pourtour = pourtour ;
    }
    
    
    
    // Accesseurs
    public Integer  id       () { return this.id ; }
    public String   nom      () { return this.nom ; }
    public Pourtour pourtour () { return this.pourtour ; }

}
