/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.donnees;



/**
 * Classe permettant de noter dans quel sens lire prendre un limes.
 */
public class LimesOrdonne
{

    private Limes   limes ;
    private boolean sensNormal ;        // Vrai = les points doivent être pris dans l'ordre dans lequel ils apparaissent dans le limes.

    
    
    /**
     * Constructeur.
     * @param limes      Le limes.
     * @param sensNormal Indique si le limes doit être parcouru dans le sens normal ou inverse.
     */
    public LimesOrdonne (Limes limes, boolean sensNormal)
    {
        this.limes      = limes ;
        this.sensNormal = sensNormal ;
    }
    
    
    
    // Accesseurs
    public Limes   limes      () { return this.limes ; }
    public boolean sensNormal () { return this.sensNormal ; }
    
}
