/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.donnees;

import fr.histoiremondiale.histoire.utiles.math.PointSphere;






/**
 * Informations sur un fleuve.
 */
public class Fleuve
{

    private Integer                 id ;
    private String                  nom ;
    private Limes     				lignes ;                        // Le tracé du fleuve est défini par un ensemble de points
    private PointSphere             centreCercleLimite ;            // Centre du cercle limite contenant le tracé du fleuve
    private double                  cosCercleLimite ;               // Cosinus du cercle limite contenant le tracé du fleuve     
    //les paramètres pour le nom n'existent que si le nom existe 
    //(les bras des deltas n'ont pas de nom)
    //on a le point du début d'écriture du nom et celui de fin d'écriture car la transformation
    //passant des points géographiques aux points sur la carte ne conserve pas les angles. L'angle 
    //de l'écriture doit se calculer à chaque fois
    private PointSphere				debut = null;					// le point où commence l'écriture
    private PointSphere				fin = null;						// le point où finit l'écriture
    
    
    /**
     * Constructeur
     * @param id                 L'identifiant du fleuve.
     * @param nom                Le nom du fleuve.
     * @param lignes             Les lignes constituant le fleuve.
     * @param centreCercleLimite Le centre du cercle contenant le fleuve.
     * @param cosCercleLimite    Le cosinus permettant de déterminer le cercle contenant le fleuve.
     * @param debut 			 le début de l'écriture du nom
     * @param fin 				 la fin de l'écriture du nom
     */
    public Fleuve (Integer id, String nom, Limes lignes, PointSphere centreCercleLimite, double cosCercleLimite, PointSphere debut, PointSphere fin)
    {
        this.id                 = id ;
        this.nom                = (nom == null ? "" : nom) ;
        this.lignes             = lignes ;
        this.centreCercleLimite = centreCercleLimite ;
        this.cosCercleLimite    = cosCercleLimite ;
        if (this.nom.isEmpty()) return;
        this.debut 				= debut;
        this.fin 				= fin;
    }
    
    
    // Accesseurs
    public Integer                 id                 () { return this.id ; } ;
    public String                  nom                () { return this.nom ; } ;
    public Limes             	   lignes             () { return this.lignes ; }
    public PointSphere             centreCercleLimite () { return this.centreCercleLimite ; } ;
    public double                  cosCercleLimite    () { return this.cosCercleLimite ; }
    public PointSphere			   debut			  () { return this.debut ; }
    public PointSphere			   fin				  () {return this.fin ; }
}
