/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire;

import java.util.List;
import java.util.Map;

import fr.histoiremondiale.histoire.donnees.Fleuve;
import fr.histoiremondiale.histoire.donnees.Limes;
import fr.histoiremondiale.histoire.donnees.Mer;
import fr.histoiremondiale.histoire.donnees.Terre;
import fr.histoiremondiale.histoire.stockage.AccesDonneesGeographiques;




/**
 * Rassemble les données géographiques pour le tracé de la carte.
 */
public class DonneesGeographiques
{

    // Données utilisées pour construire le reste
    private Map<Integer,Limes> indexLimes ;     // Limes utilisés pour définir des contours et autres tracés
    
    
    // Données principales
    private List<Terre>  terres ;       // Continents
    private List<Mer>    mers ;         // Mers intérieures
                                        // (les mers principales sont définies par l'espace non occupé par les continents)
    private List<Fleuve> fleuves ;      // Fleuves
    
    
    // Accès aux données
    private AccesDonneesGeographiques accesDonneesGeographiques ;
    
    
    
    /**
     * Constructeur.
     * @param accesDonneesGeographiques Objet d'accès aux données géographiques.
     */
    public DonneesGeographiques (AccesDonneesGeographiques accesDonneesGeographiques)
    {
        // Début du chargement des données
        long dateDeb = System.currentTimeMillis() ;
        
        // Initialiser les objets d'accès aux données
        this.accesDonneesGeographiques = accesDonneesGeographiques ;

        // Charger les limes
        this.indexLimes = this.accesDonneesGeographiques.chargerLimesIndexes() ;
        
        // Charger les données principales
        this.terres  = this.accesDonneesGeographiques.chargerTerres (this.indexLimes) ;
        this.mers    = this.accesDonneesGeographiques.chargerMers (this.indexLimes) ;
        this.fleuves = this.accesDonneesGeographiques.chargerFleuves (this.indexLimes) ;

        // Fin du chargement des données
        long dateFin = System.currentTimeMillis() ;
        
        // Afficher le compte-rendu
        // (à conserver ; si l'utilisateur ne veut rien voir, il n'affiche pas la console)
        System.out.println ("\t\tDonnées géographiques chargées en " + (dateFin - dateDeb) + " ms.") ;
        System.out.println ("\t\t\tNombre de terres chargées : " + this.terres.size()) ;
        System.out.println ("\t\t\tNombre de mers chargées   : " + this.mers.size()) ;
        System.out.println ("\t\t\tNombre de fleuves chargés : " + this.fleuves.size()) ;
    }
    
    
    // Accesseurs
    public Map<Integer,Limes> indexLimes ()
    {
        return this.indexLimes ;
    }
    public List<Terre> terres ()
    {
        return this.terres ;
    }
    public List<Mer> mers ()
    {
        return this.mers ;
    }
    public List<Fleuve> fleuves ()
    {
        return this.fleuves ;
    }

}
