/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire;

import java.io.File;



/**
 * Configuration générale de l'application (chemins d'accès aux données, ...).
 */
public class ConfigAppli
{

    private static final String NOM_VAR_ENV_CHEMIN_APPLI = "HISTOIREMONDIALE_HOME" ;
    private static final String CHEM_REP_ICONES          = "icones"   + File.separator + "histoire" ;
    private static final String CHEM_REP_ICONES_LICENCES = "icones"   + File.separator + "licences" ;
    public  static final String CHEM_REP_DOCUMENTATION   = "histoire" + File.separator + "aide";
    public  static final String CHEM_REP_PAGES_HTML      = "histoire" + File.separator + "pages-html";
    
    private String chemRepDonnees ;             // Chemin du répertoire des données
    private String chemRepDonneesLuConf ;       // Chemin du répertoire des données tel que lu dans le fichier de configuration
    private String chemRepIcones ;              // Chemin du répertoire des icônes
    private String chemRepIconesLicences ;      // Chemin du répertoire des icônes des licences
    private String chemRepDocumentation ;       // Chemin du répertoire de la documentation utilisateur
    private String chemRepPagesHtml ;           // Chemin du répertoire des pages html

    

    /**
     * Constructeur.
     * @param chemRepDonnees       Chemin du répertoire des données de l'application.
     * @param chemRepDonneesLuConf Chemin lu dans la configuration.
     */
    public ConfigAppli (String chemRepDonnees, String chemRepDonneesLuConf)
    {
        String  cheminAppliFourni  = System.getenv (NOM_VAR_ENV_CHEMIN_APPLI) ;   // Chemin fourni par une variable d'environnement
        System.out.println(chemRepDonneesLuConf);
        
        // Si le chemin est un chemin relatif et que la variable d'environnement est positionnée, ajouter le
        // préfixe
        boolean cheminRelatif = ! new File(chemRepDonnees).isAbsolute () ;
        this.chemRepDonnees =       (cheminRelatif && (cheminAppliFourni != null) ?
                                       cheminAppliFourni + File.separator + chemRepDonnees :
                                       chemRepDonnees) ;
        this.chemRepDonneesLuConf = chemRepDonneesLuConf ;
        
        // Déterminer le chemin d'accès aux autres ressources du projet
        this.chemRepIcones         = (cheminAppliFourni != null ?
                                         cheminAppliFourni + File.separator + CHEM_REP_ICONES :
                                         CHEM_REP_ICONES) ;
        this.chemRepIconesLicences = (cheminAppliFourni != null ?
                                         cheminAppliFourni + File.separator + CHEM_REP_ICONES_LICENCES :
                                         CHEM_REP_ICONES_LICENCES) ;
        this.chemRepDocumentation  = this.chemRepDonnees + File.separator + CHEM_REP_DOCUMENTATION ;
        this.chemRepPagesHtml      = this.chemRepDonnees + File.separator + CHEM_REP_PAGES_HTML ;
    }


    // Accesseurs
    // Certains accesseurs sont synchronisés pour le chargement parallèle des données principales et de
    //   celles de l'interface graphique.
    public synchronized String chemRepDonnees ()
    {
        return this.chemRepDonnees ;
    }
    public synchronized String chemRepDonneesLuConf ()
    {
        return this.chemRepDonneesLuConf ;
    }
    public synchronized String chemRepIcones ()
    {
        return this.chemRepIcones ;
    }
    public synchronized String chemRepIconesLicences ()
    {
        return this.chemRepIconesLicences ;
    }
    public synchronized String chemRepDocumentation ()
    {
        return this.chemRepDocumentation ;
    }
    public synchronized String chemRepPagesHtml ()
    {
        return this.chemRepPagesHtml ;
    }

}
