#!/bin/bash

set -e

if [ "$#" !=  "3" ]
then
    echo "Le script attend des paramètres (exemple : 'programme-2.1' '/chemin/programme-2.1-src.tar.gz' '/chemin/destination/paquet/')"
    exit 1
fi

NOM_BASE_ARCHIVE="$1"
CHEM_ARCHIVE_SOURCE="$2"
CHEM_DESTINATION_PAQUET="$3"
REP_COMPILATION=compilation-paquet--tmp--
NOM_PAQUET=histoiremondiale
EMPREINTE_MD5_ARCHIVE=`md5sum $CHEM_ARCHIVE_SOURCE | awk '{ print $1 }'`

# Créer les répertoires
rm -rf $REP_COMPILATION
mkdir $REP_COMPILATION

# Rassembler les informations pour créer le paquet
cp $CHEM_ARCHIVE_SOURCE $REP_COMPILATION/
cp ../../../'%notes de version.txt' $REP_COMPILATION/
cp PKGBUILD $REP_COMPILATION/
sed -i -e "s/'empreinte-md5-a-remplir'/'$EMPREINTE_MD5_ARCHIVE'/g" $REP_COMPILATION/PKGBUILD

# Créer le paquet
cd $REP_COMPILATION
makepkg
cd ..
cp $REP_COMPILATION/*.tar.xz $CHEM_DESTINATION_PAQUET

# Nettoyer le répertoire temporaire
rm -rf $REP_COMPILATION
