/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.es.fichiers;

import fr.histoiremondiale.histoire.utiles.exttypes.Chaines;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Fichiers {
    public static String urlLocaleDeNomFichier(String string) {
        return "file:///" + new File(string).getAbsolutePath().replace(File.separator, "/");
    }

    public static String chargerContenuTexte(String string, String string2) throws IOException {
        return Fichiers.chargerContenuTexte(new File(string), string2);
    }

    public static String chargerContenuTexte(String string) throws IOException {
        return Fichiers.chargerContenuTexte(string, "UTF-8");
    }

    public static String chargerContenuTexte(File file) throws IOException {
        return Fichiers.chargerContenuTexte(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String chargerContenuTexte(File file, String string) throws IOException {
        StringBuilder stringBuilder;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            stringBuilder = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sauverContenuTexte(String string, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string3));
            printWriter.write(string);
            fileOutputStream.getFD().sync();
            printWriter.close();
            printWriter = null;
        }
        finally {
            if (printWriter != null) {
                try {
                    fileOutputStream.getFD().sync();
                }
                catch (Throwable throwable) {}
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static boolean creerRepertoires(String string) {
        return Fichiers.creerRepertoires(new File(string));
    }

    public static boolean creerRepertoires(File file) {
        file.mkdirs();
        return file.exists() && file.isDirectory();
    }

    public static void renommer(File file, File file2, boolean bl) {
        if (!file.exists()) {
            throw new RuntimeException("Impossible de renommer " + file.getAbsolutePath() + ": le fichier n'existe pas.");
        }
        if (file2.exists()) {
            if (bl) {
                file2.delete();
            } else {
                throw new RuntimeException("Impossible de renommer " + file.getAbsolutePath() + " en " + file2.getAbsolutePath() + " : le fichier destination existe d\u00e9j\u00e0.");
            }
        }
        file.renameTo(file2);
    }

    public static boolean extensionEgale(String string, String string2) {
        if (string.length() < string2.length() + 1) {
            return false;
        }
        String string3 = Chaines.sousChaine(string, string.length() - string2.length() - 1);
        return string3.equalsIgnoreCase("." + string2);
    }

    public static void ecrireFichier(String string, String string2) {
        try {
            Fichiers.sauverContenuTexte(string2, string, "UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static byte[] chargerContenuBinaire(String string) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
        return byteArrayOutputStream.toByteArray();
    }
}

