/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import fr.histoiremondiale.histoire.donnees.Pourtour;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosImage;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;

public class InfosTracerImage {
    public InfosImage ancImg = new InfosImage();
    public InfosImage nouvImg = new InfosImage();

    public boolean imageDisponible() {
        return this.ancImg.image != null;
    }

    public List<Polygon> polygonesTraces(int n) {
        List<Polygon> list = this.nouvImg.multiPolygonesPourtoursTraces.get(n);
        if (list != null) {
            return list;
        }
        return null;
    }

    public boolean territoireConnu(int n) {
        return this.nouvImg.territoiresTraces.containsKey(n);
    }

    public boolean pointPlanConnu(PointSphere pointSphere) {
        return this.nouvImg.cachePoints.containsKey(pointSphere);
    }

    public PointPlan pointPlan(PointSphere pointSphere) {
        return this.nouvImg.cachePoints.get(pointSphere);
    }

    public Territoire territoireAuxCoordonnees(double d, double d2) {
        Territoire territoire = null;
        for (Territoire territoire2 : this.ancImg.territoiresTraces.values()) {
            Pourtour pourtour = territoire2.pourtour();
            if (this.ancImg.multiPolygonesPourtoursTraces.get(pourtour.id()) == null) continue;
            for (Polygon polygon : this.ancImg.multiPolygonesPourtoursTraces.get(pourtour.id())) {
                if (!polygon.contains(d, d2) || territoire != null && territoire2.rang() <= territoire.rang()) continue;
                territoire = territoire2;
            }
        }
        return territoire;
    }

    public Territoire territoireTexteAuxCoordonnees(double d, double d2) {
        Territoire territoire = null;
        for (Map.Entry<Rectangle, Territoire> entry : this.ancImg.textesTerritoiresTraces.entrySet()) {
            if (!entry.getKey().contains(d, d2) || territoire != null && territoire.rang() >= entry.getValue().rang()) continue;
            territoire = entry.getValue();
        }
        return territoire;
    }

    public boolean perimee() {
        return this.ancImg.perimee;
    }

    public void terminerTracer() {
        this.ancImg = this.nouvImg;
        this.nouvImg = new InfosImage();
    }
}

