/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.stockage;

import fr.histoiremondiale.histoire.DonneesHistoriques;
import fr.histoiremondiale.histoire.DonneesIGraphique;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.stockage.AccesDonneesBase;
import fr.histoiremondiale.histoire.utiles.es.fichiers.Fichiers;
import fr.histoiremondiale.histoire.utiles.es.fichiers.Proprietes;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class AccesDonneesIGraphique
extends AccesDonneesBase {
    public static final String ENCODAGE_PAGES_HTML = "UTF-8";
    public static final String NOM_REP_DONNEES_PARAGRAPHES = "histoire" + File.separator + "paragraphes";
    public static final String PREFIXE_NOM_FIC_PARAGRAPHES = "paragraphe";
    public static final String SUFFIXE_NOM_FIC_PARAGRAPHES = ".txt";
    public static final String ENCODAGE_FIC_POSITIONS = "UTF-8";
    public static final String NOM_FIC_DEBUT_HTML = "debutPage.txt";
    public static final String NOM_FIC_FIN_HTML = "finPage.txt";
    public static final String CHEM_FIC_POSITIONS = System.getProperty("user.home") + File.separator + ".config/histoiremondiale/positions.conf".replace('/', File.separatorChar);
    public static final String ENCODAGE_FIC_LOUPES = "UTF-8";
    public static final String CHEM_FIC_LOUPES = System.getProperty("user.home") + File.separator + ".config/histoiremondiale/loupes.conf".replace('/', File.separatorChar);
    private String chemRepDonnees;
    private String chemRepIcones;

    public AccesDonneesIGraphique(String string, String string2) {
        super(string);
        this.chemRepDonnees = string;
        this.chemRepIcones = string2;
    }

    public void sauverInfosIGraphique(DonneesIGraphique donneesIGraphique) throws IOException {
        this.sauverPositionTextes(donneesIGraphique);
        this.sauverValeursLoupeTerritoire(donneesIGraphique);
    }

    public List<InfosParagrapheNavig> chargerInfosParagraphesNavig(DonneesHistoriques donneesHistoriques) throws IOException {
        long l;
        long l2 = l = System.currentTimeMillis();
        try {
            Object object;
            Object object2;
            String string = "SELECT *  FROM paragraphes";
            String string2 = "SELECT *  FROM suivants_paragraphes";
            HashMap<Integer, InfosParagrapheNavig> hashMap = new HashMap<Integer, InfosParagrapheNavig>();
            ResultSet resultSet = AccesDonneesIGraphique.connexionCourante().prepareStatement(string).executeQuery();
            while (resultSet.next()) {
                InfosParagrapheNavig infosParagrapheNavig = new InfosParagrapheNavig(resultSet.getInt("id"), donneesHistoriques.civilisationDId(resultSet.getInt("id_civilisation")), resultSet.getInt("debut"), resultSet.getInt("fin"), resultSet.getString("titre"));
                hashMap.put(infosParagrapheNavig.id(), infosParagrapheNavig);
            }
            long l3 = System.currentTimeMillis();
            System.out.println("\t\t\t\tfin du chargement des paragraphes en : " + (l3 - l) + " ms");
            l = System.currentTimeMillis();
            ResultSet resultSet2 = AccesDonneesIGraphique.connexionCourante().prepareStatement(string2).executeQuery();
            while (resultSet2.next()) {
                object2 = (InfosParagrapheNavig)hashMap.get(resultSet2.getInt("id_courant"));
                object = (InfosParagrapheNavig)hashMap.get(resultSet2.getInt("id_suivant"));
                ((InfosParagrapheNavig)object2).suivants().add((InfosParagrapheNavig)object);
                ((InfosParagrapheNavig)object).precedents().add((InfosParagrapheNavig)object2);
            }
            resultSet.close();
            resultSet2.close();
            l3 = System.currentTimeMillis();
            l = System.currentTimeMillis();
            object2 = this.chemRepDonnees + File.separator + NOM_REP_DONNEES_PARAGRAPHES + File.separator;
            object = Fichiers.chargerContenuTexte((String)object2 + NOM_FIC_DEBUT_HTML, "UTF-8");
            String string3 = Fichiers.chargerContenuTexte((String)object2 + NOM_FIC_FIN_HTML, "UTF-8");
            String string4 = "<div align=\"center\"><a href=\"bibliographie.html\"><img src = \"file:" + this.chemRepIcones + File.separator + "booksmini16.png\"     alt = \"Bibliographie\" border = \"0\"></a></div>";
            for (InfosParagrapheNavig infosParagrapheNavig : hashMap.values()) {
                String string5 = (String)object2 + PREFIXE_NOM_FIC_PARAGRAPHES + new DecimalFormat("0000").format(infosParagrapheNavig.id()) + SUFFIXE_NOM_FIC_PARAGRAPHES;
                File file = new File(string5);
                String string6 = "<h1>Paragraphe absent</h1>";
                if (file.exists()) {
                    string6 = "<br>" + Fichiers.chargerContenuTexte((String)object2 + PREFIXE_NOM_FIC_PARAGRAPHES + new DecimalFormat("0000").format(infosParagrapheNavig.id()) + SUFFIXE_NOM_FIC_PARAGRAPHES, "UTF-8") + "<br>";
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n<strong style=\"color:red\">");
                if (infosParagrapheNavig.civilisation() != null) {
                    stringBuilder.append(StringEscapeUtils.escapeHtml(infosParagrapheNavig.civilisation().nom()));
                    stringBuilder.append(" (");
                    stringBuilder.append(infosParagrapheNavig.anneeDeb());
                    stringBuilder.append(" \u00e0 ");
                    stringBuilder.append(infosParagrapheNavig.anneeFin());
                    stringBuilder.append(") : ");
                }
                stringBuilder.append(StringEscapeUtils.escapeHtml(infosParagrapheNavig.titre()));
                stringBuilder.append("</strong>\n\n");
                String string7 = stringBuilder.toString();
                StringBuilder stringBuilder2 = new StringBuilder();
                if (infosParagrapheNavig.precedents().size() + infosParagrapheNavig.suivants().size() > 0) {
                    stringBuilder2.append("<table width=\"100%\">");
                    stringBuilder2.append("<tr>");
                    stringBuilder2.append("<td>");
                    int n = 0;
                    for (InfosParagrapheNavig infosParagrapheNavig2 : infosParagrapheNavig.precedentsTries()) {
                        Object object3 = "Pr\u00e9c\u00e9dent" + (infosParagrapheNavig2.civilisation() != null && !infosParagrapheNavig2.civilisation().equals(infosParagrapheNavig.civilisation()) ? " : " + StringEscapeUtils.escapeHtml(infosParagrapheNavig2.civilisation().nom()) : "");
                        if (n++ > 0) {
                            stringBuilder2.append("<br>");
                        }
                        stringBuilder2.append("<a href=\"#" + StringEscapeUtils.escapeHtml(infosParagrapheNavig2.ancre()) + "\">" + (String)object3 + "</a>\n");
                    }
                    stringBuilder2.append("</td>");
                    stringBuilder2.append("<td align=\"right\">");
                    int n2 = 0;
                    for (Object object3 : infosParagrapheNavig.suivantsTries()) {
                        String string8 = "Suivant" + (((InfosParagrapheNavig)object3).civilisation() != null && !((InfosParagrapheNavig)object3).civilisation().equals(infosParagrapheNavig.civilisation()) ? " : " + StringEscapeUtils.escapeHtml(((InfosParagrapheNavig)object3).civilisation().nom()) : "");
                        if (n2++ > 0) {
                            stringBuilder2.append("<br>");
                        }
                        stringBuilder2.append("<a href=\"#" + StringEscapeUtils.escapeHtml(((InfosParagrapheNavig)object3).ancre()) + "\">" + string8 + "</a>\n");
                    }
                    stringBuilder2.append("</td>");
                    stringBuilder2.append("</tr>");
                    stringBuilder2.append("</table>");
                }
                infosParagrapheNavig.modifCodeHtml((String)object + "<br>" + string7 + stringBuilder2 + string6 + stringBuilder2 + string4 + "<br>" + string3);
                infosParagrapheNavig.modifCodeHtmlSimple(string7 + string6);
            }
            l3 = System.currentTimeMillis();
            System.out.println("\t\t\t\tfin du chargement du texte des paragraphes en : " + (l3 - l) + " ms");
            l = System.currentTimeMillis();
            ArrayList arrayList = new ArrayList(hashMap.values());
            Collections.sort(arrayList);
            l3 = System.currentTimeMillis();
            System.out.println("\t\t\t\tfin du tri des paragraphes en : " + (l3 - l) + " ms");
            System.out.println("\t\t\t\ttemps total pour les paragraphes : " + (l3 - l2) + " ms");
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Erreur lors du chargement des donn\u00e9es", sQLException);
        }
    }

    public Map<Territoire, PointSphere> chargerPositionTextes(DonneesHistoriques donneesHistoriques) throws IOException {
        Properties properties = Proprietes.chargerProprietes(CHEM_FIC_POSITIONS, "UTF-8");
        HashMap<Territoire, PointSphere> hashMap = new HashMap<Territoire, PointSphere>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            int n = Integer.parseInt("" + entry.getKey());
            double d = Double.parseDouble(entry.getValue().toString().split(",")[0]);
            double d2 = Double.parseDouble(entry.getValue().toString().split(",")[1]);
            Territoire territoire = donneesHistoriques.territoireParId(n);
            if (territoire != null) {
                hashMap.put(territoire, new PointSphere(d, d2));
                continue;
            }
            hashMap.put(new Territoire(n), new PointSphere(d, d2));
        }
        return hashMap;
    }

    public void sauverPositionTextes(DonneesIGraphique donneesIGraphique) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<Territoire, PointSphere> entry : donneesIGraphique.centresTextesTerritoires().entrySet()) {
            Territoire territoire = entry.getKey();
            PointSphere pointSphere = entry.getValue();
            if (territoire == null) continue;
            properties.put("" + territoire.id(), "" + pointSphere.longitude() + "," + pointSphere.latitude());
        }
        Proprietes.sauverProprietes(properties, "Position des textes d\u00e9plac\u00e9s de HistoireMondiale", CHEM_FIC_POSITIONS, "UTF-8");
    }

    public Map<Territoire, Double> chargerValeursLoupeTerritoire(DonneesHistoriques donneesHistoriques) throws IOException {
        Properties properties = Proprietes.chargerProprietes(CHEM_FIC_LOUPES, "UTF-8");
        HashMap<Territoire, Double> hashMap = new HashMap<Territoire, Double>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            int n = Integer.parseInt("" + entry.getKey());
            double d = Double.parseDouble("" + entry.getValue());
            Territoire territoire = donneesHistoriques.territoireParId(n);
            if (territoire != null) {
                hashMap.put(territoire, d);
                continue;
            }
            hashMap.put(new Territoire(n), d);
        }
        return hashMap;
    }

    public void sauverValeursLoupeTerritoire(DonneesIGraphique donneesIGraphique) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<Territoire, Double> entry : donneesIGraphique.loupesTextesTerritoires().entrySet()) {
            Territoire territoire = entry.getKey();
            Double d = entry.getValue();
            if (territoire == null) continue;
            properties.put("" + territoire.id(), "" + d);
        }
        Proprietes.sauverProprietes(properties, "Valeurs de loupe minimale modifi\u00e9es pour les textes des territoires de Histoire Mondiale", CHEM_FIC_LOUPES, "UTF-8");
    }
}

