/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import fr.histoiremondiale.histoire.DonneesIGraphique;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Fleuve;
import fr.histoiremondiale.histoire.donnees.Limes;
import fr.histoiremondiale.histoire.donnees.Mer;
import fr.histoiremondiale.histoire.donnees.Pourtour;
import fr.histoiremondiale.histoire.donnees.Terre;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.donnees.TexteTerritoire;
import fr.histoiremondiale.histoire.igraphique.tracercartes.EntreeSortie;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosImage;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosTracerImage;
import fr.histoiremondiale.histoire.igraphique.tracercartes.TexteCarte;
import fr.histoiremondiale.histoire.utiles.exttypes.Chaines;
import fr.histoiremondiale.histoire.utiles.igraphique.dessin.hachures.PeintureHachures;
import fr.histoiremondiale.histoire.utiles.math.CalculsPlan;
import fr.histoiremondiale.histoire.utiles.math.CoordSphere;
import fr.histoiremondiale.histoire.utiles.math.Matrice;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TraceurCarte {
    public static boolean TEST = false;
    private static Font fonteEcolier = new Font("Ecolier", 0, 36);
    private static final int HACHURES_AUCUNE = 0;
    private static final int LIGNE_AUCUNE = 0;
    private static final int LIGNE_PLEINE_1 = 1;
    private static final Color COUL_DEFAUT_HACHURES = Color.BLACK;
    private static final double ESPACE_HACHURES = 10.0;
    private static final double EPAISSEUR_HACHURES = 2.0;
    private static final int LARGEUR_FLOU_HACHURES = 25;
    private static final PeintureHachures[][] PEINTURES_HACHURES = new PeintureHachures[][]{new PeintureHachures[0], {new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 0.0, 2.0, 25)}, {new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 1.5707963267948966, 2.0, 25)}, {new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 2.356194490192345, 2.0, 25)}, {new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 0.7853981633974483, 2.0, 25)}, {new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 0.0, 2.0, 25), new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 1.5707963267948966, 2.0, 25)}, {new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 2.356194490192345, 2.0, 25), new PeintureHachures(COUL_DEFAUT_HACHURES, 10.0, 0.7853981633974483, 2.0, 25)}};
    private static final int FORME_BOUT_FRONTIERE = 1;
    private static final int FORME_ANGLE_FRONTIERE = 1;
    private static final float ANGLE_MIN_BOUT_TRIANGLE = 1.0f;
    private static final float DECALAGE_MOTIF = 0.0f;
    private static final Stroke[] STYLES_FRONTIERES = new Stroke[]{null, new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f, 0.0f}, 0.0f), new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{1.0f, 0.0f}, 0.0f), new BasicStroke(3.0f, 1, 1, 1.0f, new float[]{1.0f, 0.0f}, 0.0f), new BasicStroke(4.0f, 1, 1, 1.0f, new float[]{1.0f, 0.0f}, 0.0f), new BasicStroke(5.0f, 1, 1, 1.0f, new float[]{1.0f, 0.0f}, 0.0f), new BasicStroke(6.0f, 1, 1, 1.0f, new float[]{1.0f, 0.0f}, 0.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{15.0f, 5.0f}, 0.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 5.0f, 8.0f, 5.0f}, 0.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 5.0f, 3.0f, 5.0f, 8.0f, 5.0f}, 0.0f)};

    public void tracerCarte(List<Terre> list, List<Mer> list2, List<Fleuve> list3, List<Territoire> list4, int n, boolean bl, boolean bl2, PointSphere pointSphere, int n2, int n3, double d, Color color, Color color2, Color color3, Graphics graphics, InfosTracerImage infosTracerImage) {
        Color color4 = graphics.getColor();
        InfosImage infosImage = infosTracerImage.nouvImg;
        if (infosImage.imgCompleteSansTextes == null) {
            infosImage.imgCompleteSansTextes = new BufferedImage(n2, n3, 6);
            Graphics graphics2 = infosImage.imgCompleteSansTextes.getGraphics();
            this.tracerMersPrincipales(color, graphics2, n2, n3);
            this.tracerTerres(list, color2, graphics2, n2, n3, d, pointSphere, infosTracerImage);
            this.tracerFondTerritoires(list4, graphics2, n2, n3, d, pointSphere, infosTracerImage);
            this.tracerMers(list2, color, graphics2, n2, n3, d, pointSphere, infosTracerImage);
            if (bl) {
                this.tracerFleuves(list3, color3, graphics2, n2, n3, d, pointSphere, infosTracerImage);
            }
            if (bl2) {
                this.tracerMeridiensParalleles(graphics2, n2, n3, d, pointSphere, infosTracerImage);
            }
        }
        graphics.drawImage(infosImage.imgCompleteSansTextes, 0, 0, null);
        this.tracerTextesTerritoires(list4, n, graphics, n2, n3, d, pointSphere, infosTracerImage);
        graphics.setColor(color4);
    }

    public void tracerMersPrincipales(Color color, Graphics graphics, int n, int n2) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(color2);
    }

    public void tracerTerres(List<Terre> list, Color color, Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        double d2 = TraceurCarte.rayonCarte(n, n2, d, pointSphere);
        for (Terre terre : list) {
            Object object;
            Object object2;
            if (!this.proche(terre.pourtour(), pointSphere, d2)) continue;
            List<Polygon> list2 = infosTracerImage.polygonesTraces(terre.pourtour().id());
            if (list2 == null && !(object2 = this.determinerContours(terre.pourtour().points(), n, n2, d, pointSphere, infosTracerImage)).isEmpty()) {
                list2 = new ArrayList<Polygon>();
                object = object2.iterator();
                while (object.hasNext()) {
                    List list3 = (List)object.next();
                    list2.add(this.polygonePourTrace(list3));
                }
                infosTracerImage.nouvImg.multiPolygonesPourtoursTraces.put(terre.pourtour().id(), list2);
            }
            if (list2 == null) continue;
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                this.tracerRegion((Polygon)object, color, null, 0, graphics);
            }
        }
    }

    public void tracerFondTerritoires(List<Territoire> list, Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        double d2 = TraceurCarte.rayonCarte(n, n2, d, pointSphere);
        for (Territoire territoire : list) {
            Object object;
            Object object2;
            if (!this.proche(territoire.pourtour(), pointSphere, d2)) continue;
            List<Polygon> list2 = infosTracerImage.polygonesTraces(territoire.pourtour().id());
            if (list2 == null && !(object2 = this.determinerContours(territoire.pourtour().points(), n, n2, d, pointSphere, infosTracerImage)).isEmpty()) {
                list2 = new ArrayList<Polygon>();
                object = object2.iterator();
                while (object.hasNext()) {
                    List list3 = (List)object.next();
                    list2.add(this.polygonePourTrace(list3));
                }
                infosTracerImage.nouvImg.multiPolygonesPourtoursTraces.put(territoire.pourtour().id(), list2);
                infosTracerImage.nouvImg.territoiresTraces.put(territoire.id(), territoire);
            }
            if (!infosTracerImage.territoireConnu(territoire.id())) {
                infosTracerImage.nouvImg.territoiresTraces.put(territoire.id(), territoire);
            }
            if (list2 == null) continue;
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (Polygon)object2.next();
                this.tracerRegion((Polygon)object, territoire.coulInterieur(), territoire.coulFrontieres(), territoire.styleHachures(), graphics);
                if (territoire.styleFrontieres() <= 0) continue;
                this.tracerFrontieres((Polygon)object, territoire.coulFrontieres(), territoire.styleFrontieres(), graphics);
            }
        }
    }

    public void tracerMers(List<Mer> list, Color color, Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        double d2 = TraceurCarte.rayonCarte(n, n2, d, pointSphere);
        for (Mer mer : list) {
            Object object;
            Object object2;
            if (!this.proche(mer.pourtour(), pointSphere, d2)) continue;
            List<Polygon> list2 = infosTracerImage.polygonesTraces(mer.pourtour().id());
            if (list2 == null && !(object2 = this.determinerContours(mer.pourtour().points(), n, n2, d, pointSphere, infosTracerImage)).isEmpty()) {
                list2 = new ArrayList<Polygon>();
                object = object2.iterator();
                while (object.hasNext()) {
                    List list3 = (List)object.next();
                    list2.add(this.polygonePourTrace(list3));
                }
                infosTracerImage.nouvImg.multiPolygonesPourtoursTraces.put(mer.pourtour().id(), list2);
            }
            if (list2 == null) continue;
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                this.tracerRegion((Polygon)object, color, null, 0, graphics);
            }
        }
    }

    public void tracerFleuves(List<Fleuve> list, Color color, Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        double d2 = TraceurCarte.rayonCarte(n, n2, d, pointSphere);
        for (Fleuve fleuve : list) {
            if (!this.proche(fleuve, pointSphere, d2)) continue;
            Limes limes = fleuve.lignes();
            List<PointPlan> list2 = this.determinerLigneBrisee(limes.points(), n, n2, d, pointSphere, infosTracerImage);
            if (!list2.isEmpty()) {
                this.tracerLigneBrisee(CalculsPlan.changementOrigineCentreVersCoinHautGauche(list2, n, n2), color, 1, graphics);
            }
            if (fleuve.nom().isEmpty()) continue;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Font font = graphics2D.getFont();
            Color color2 = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            String string = fleuve.nom();
            float f = (float)(16.0 + 5.0 * (d - 1.0));
            Font font2 = fonteEcolier.deriveFont(f);
            graphics2D.setFont(font2);
            graphics2D.setColor(color);
            Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
            int n3 = Math.max(n, n2);
            PointPlan pointPlan = CoordSphere.projection(fleuve.debut(), matrice, d, n3);
            pointPlan = CalculsPlan.changementOrigineCentreVersCoinHautGauche(pointPlan, n, n2);
            int n4 = (int)pointPlan.x();
            int n5 = (int)pointPlan.y();
            PointPlan pointPlan2 = CoordSphere.projection(fleuve.fin(), matrice, d, n3);
            pointPlan2 = CalculsPlan.changementOrigineCentreVersCoinHautGauche(pointPlan2, n, n2);
            int n6 = (int)pointPlan2.x();
            int n7 = (int)pointPlan2.y();
            int n8 = n6 - n4;
            int n9 = n7 - n5;
            int n10 = n8 * n8;
            int n11 = n9 * n9;
            double d3 = Math.sqrt(n10 + n11);
            double d4 = Math.asin((double)n9 / d3);
            if (n8 < 0) {
                d4 = Math.PI - d4;
            }
            graphics2D.rotate(d4, n4, n5);
            graphics2D.drawString(string, n4, n5);
            graphics2D.setTransform(affineTransform);
            graphics2D.setFont(font);
            graphics2D.setColor(color2);
        }
    }

    private List<PointPlan> determinerLigneBrisee(List<PointSphere> list, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        ArrayList<PointPlan> arrayList = new ArrayList<PointPlan>();
        PointPlan pointPlan = null;
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
        int n3 = Math.max(n, n2);
        for (PointSphere pointSphere2 : list) {
            PointPlan pointPlan2;
            boolean bl = infosTracerImage != null && infosTracerImage.pointPlanConnu(pointSphere2);
            PointPlan pointPlan3 = pointPlan2 = bl ? infosTracerImage.pointPlan(pointSphere2) : CoordSphere.projection(pointSphere2, matrice, d, n3);
            if (!bl) {
                infosTracerImage.nouvImg.cachePoints.put(pointSphere2, pointPlan2);
            }
            if (pointPlan != null && pointPlan.confonduCoordEntieres(pointPlan2)) continue;
            pointPlan = pointPlan2;
            arrayList.add(pointPlan2);
        }
        return arrayList;
    }

    private List<List<PointPlan>> determinerContours(List<PointSphere> list, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        ArrayList<PointPlan> arrayList = new ArrayList<PointPlan>();
        PointPlan pointPlan = null;
        PointSphere pointSphere2 = list.get(0);
        double d2 = TraceurCarte.rayonCarte(n, n2, d, pointSphere);
        boolean bl = pointSphere.DansLeCercle(pointSphere2, d2);
        LinkedList<EntreeSortie> linkedList = new LinkedList<EntreeSortie>();
        Polygon polygon = new Polygon();
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
        int n3 = Math.max(n, n2);
        double d3 = Math.sqrt(n * n + n2 * n2) / 2.0;
        for (int i = 0; i < list.size(); ++i) {
            PointPlan pointPlan2;
            PointPlan pointPlan3;
            PointSphere pointSphere3 = list.get((i + 1) % list.size());
            boolean bl2 = pointSphere.DansLeCercle(pointSphere3, d2);
            if (bl) {
                if (infosTracerImage != null && infosTracerImage.pointPlanConnu(pointSphere2)) {
                    pointPlan3 = infosTracerImage.pointPlan(pointSphere2);
                } else {
                    pointPlan3 = CoordSphere.projection(pointSphere2, matrice, d, n3);
                    infosTracerImage.nouvImg.cachePoints.put(pointSphere2, pointPlan3);
                }
                if (pointPlan == null || !pointPlan.confonduCoordEntieres(pointPlan3)) {
                    pointPlan = pointPlan3;
                    arrayList.add(pointPlan3);
                }
                if (bl2) {
                    pointSphere2 = pointSphere3;
                    bl = true;
                    continue;
                }
                if (infosTracerImage != null && infosTracerImage.pointPlanConnu(pointSphere3)) {
                    pointPlan2 = infosTracerImage.pointPlan(pointSphere3);
                } else {
                    pointPlan2 = CoordSphere.projection(pointSphere3, matrice, d, n3);
                    infosTracerImage.nouvImg.cachePoints.put(pointSphere3, pointPlan2);
                }
                PointPlan pointPlan4 = CalculsPlan.intersectionSegmentCercle(pointPlan3, pointPlan2, d3);
                if (pointPlan4.x() == Double.NaN || pointPlan4.y() == Double.NaN) {
                    System.out.println("carte (lxh) " + n + "x" + n2);
                    System.out.println("rayon = " + d3);
                    System.out.println("loupe = " + d);
                    System.out.println("centre = " + pointSphere.enChaineElaboree());
                    System.out.println("point dans le cercle " + pointSphere2.enChaineElaboree());
                    System.out.println("point hors du cercle " + pointSphere3.enChaineElaboree());
                    pointPlan4 = pointPlan4.x() == Double.NaN ? pointPlan3 : pointPlan2;
                }
                arrayList.add(pointPlan4);
                pointPlan = pointPlan4;
                linkedList.add(new EntreeSortie(1, pointPlan4, arrayList.size() - 1));
                pointSphere2 = pointSphere3;
                bl = false;
                continue;
            }
            if (bl2) {
                if (infosTracerImage != null && infosTracerImage.pointPlanConnu(pointSphere2)) {
                    pointPlan3 = infosTracerImage.pointPlan(pointSphere2);
                } else {
                    pointPlan3 = CoordSphere.projection(pointSphere2, matrice, d, n3);
                    infosTracerImage.nouvImg.cachePoints.put(pointSphere2, pointPlan3);
                }
                if (infosTracerImage != null && infosTracerImage.pointPlanConnu(pointSphere3)) {
                    pointPlan2 = infosTracerImage.pointPlan(pointSphere3);
                } else {
                    pointPlan2 = CoordSphere.projection(pointSphere3, matrice, d, n3);
                    infosTracerImage.nouvImg.cachePoints.put(pointSphere3, pointPlan2);
                }
                PointPlan pointPlan5 = CalculsPlan.intersectionSegmentCercle(pointPlan2, pointPlan3, d3);
                if (pointPlan5.x() == Double.NaN || pointPlan5.y() == Double.NaN) {
                    System.out.println("carte (lxh) " + n + "x" + n2);
                    System.out.println("rayon = " + d3);
                    System.out.println("loupe = " + d);
                    System.out.println("centre = " + pointSphere.enChaineElaboree());
                    System.out.println("point dans le cercle " + pointSphere2.enChaineElaboree());
                    System.out.println("point hors du cercle " + pointSphere3.enChaineElaboree());
                    pointPlan5 = pointPlan5.x() == Double.NaN ? pointPlan2 : pointPlan3;
                }
                arrayList.add(pointPlan5);
                pointPlan = pointPlan5;
                linkedList.add(new EntreeSortie(0, pointPlan5, arrayList.size() - 1));
                pointSphere2 = pointSphere3;
                bl = true;
                continue;
            }
            if (arrayList.isEmpty()) {
                double d4 = pointSphere2.longitude();
                if (d4 < -168.0) {
                    d4 += 360.0;
                }
                double d5 = pointSphere2.latitude();
                polygon.addPoint((int)(100.0 * d4), (int)(100.0 * d5));
            }
            pointSphere2 = pointSphere3;
            bl = false;
        }
        return this.ConstruireContours(arrayList, linkedList, polygon, pointSphere, n, n2);
    }

    private List<List<PointPlan>> ConstruireContours(List<PointPlan> list, List<EntreeSortie> list2, Polygon polygon, PointSphere pointSphere, int n, int n2) {
        List<List<PointPlan>> list3 = new ArrayList<List<PointPlan>>();
        if (list.isEmpty()) {
            double d;
            double d2 = 100.0 * pointSphere.longitude();
            if (d2 < -168.0) {
                d2 += 360.0;
            }
            if (polygon.contains(d2, d = 100.0 * pointSphere.latitude())) {
                ArrayList<PointPlan> arrayList = new ArrayList<PointPlan>();
                arrayList.add(new PointPlan(0.0, 0.0));
                arrayList.add(new PointPlan(0.0, n2));
                arrayList.add(new PointPlan(n, n2));
                arrayList.add(new PointPlan(n, 0.0));
                list3.add(arrayList);
            }
            return list3;
        }
        double d = Math.sqrt(n * n + n2 * n2) / 2.0;
        if (list2.isEmpty()) {
            list3.add(list);
        } else {
            list3 = this.genererContoursATracer(list, list2, d);
        }
        return CalculsPlan.changementOrigineCentreVersCoinHautGauchePourTout(list3, n, n2);
    }

    private List<List<PointPlan>> genererContoursATracer(List<PointPlan> list, List<EntreeSortie> list2, double d) {
        EntreeSortie entreeSortie;
        Object object;
        if (list2.get(0).isSortie()) {
            list2.add(list2.remove(0));
        }
        ArrayList<EntreeSortie> arrayList = new ArrayList<EntreeSortie>(list2);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (!arrayList.isEmpty()) {
            object = (EntreeSortie)arrayList.get(1);
            ArrayList arrayList3 = new ArrayList();
            boolean bl = false;
            while (!bl) {
                double d2 = Math.toDegrees(((EntreeSortie)object).getAngle());
                int n = this.indiceEntreeSuivante(arrayList, d2);
                entreeSortie = (EntreeSortie)arrayList.remove(n);
                arrayList3.add(entreeSortie);
                EntreeSortie entreeSortie2 = (EntreeSortie)arrayList.remove(n);
                arrayList3.add(entreeSortie2);
                bl = n == 0;
                object = entreeSortie2;
            }
            arrayList2.add(arrayList3);
        }
        object = new ArrayList();
        for (List list3 : arrayList2) {
            ArrayList<PointPlan> arrayList4 = new ArrayList<PointPlan>();
            for (int i = 0; i < list3.size(); i += 2) {
                EntreeSortie entreeSortie3 = (EntreeSortie)list3.get(i);
                entreeSortie = (EntreeSortie)list3.get(i + 1);
                int n = entreeSortie3.getIndex();
                int n2 = entreeSortie.getIndex();
                int n3 = n;
                arrayList4.add(list.get(n3));
                do {
                    n3 = (n3 + 1) % list.size();
                    arrayList4.add(list.get(n3));
                } while (n3 != n2);
                EntreeSortie entreeSortie4 = (EntreeSortie)list3.get((i + 2) % list3.size());
                double d3 = Math.toDegrees(entreeSortie.getAngle());
                double d4 = Math.toDegrees(entreeSortie4.getAngle());
                if (d4 < d3) {
                    d4 += 360.0;
                }
                for (double d5 = TraceurCarte.multipleDe10Sup(d3); d5 < d4; d5 += 10.0) {
                    arrayList4.add(CalculsPlan.creerPointCoordAngulaires(d, Math.toRadians(d5 % 360.0)));
                }
            }
            object.add(arrayList4);
        }
        return object;
    }

    private int indiceEntreeSuivante(List<EntreeSortie> list, double d) {
        double d2 = 1000.0;
        int n = -1;
        for (int i = 0; i < list.size(); i += 2) {
            EntreeSortie entreeSortie = list.get(i);
            double d3 = Math.toDegrees(entreeSortie.getAngle()) - d;
            if (d3 < 0.0) {
                d3 += 360.0;
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
            n = i;
        }
        return n;
    }

    private void tracerLigneBrisee(List<PointPlan> list, Color color, int n, Graphics graphics) {
        if (list.isEmpty() || n == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int[][] nArray = this.coordPourTrace(list);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        graphics2D.setStroke(STYLES_FRONTIERES[n]);
        graphics2D.setColor(color);
        graphics2D.drawPolyline(nArray2, nArray3, nArray2.length);
    }

    private void tracerRegion(Polygon polygon, Color color, Color color2, int n, Graphics graphics) {
        if (polygon.npoints == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        graphics2D.fillPolygon(polygon);
        if (n != 0) {
            Paint paint = graphics2D.getPaint();
            for (PeintureHachures peintureHachures : PEINTURES_HACHURES[n]) {
                peintureHachures.modifCoulHachures(color2);
                graphics2D.setPaint(peintureHachures);
                graphics2D.fillPolygon(polygon);
            }
            graphics2D.setPaint(paint);
        }
    }

    private Polygon polygonePourTrace(List<PointPlan> list) {
        int[][] nArray = this.coordPourTrace(list);
        return new Polygon(nArray[0], nArray[1], nArray[0].length);
    }

    private int[][] coordPourTrace(List<PointPlan> list) {
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PointPlan pointPlan = list.get(i);
            nArray[i] = (int)pointPlan.x();
            nArray2[i] = (int)pointPlan.y();
        }
        return new int[][]{nArray, nArray2};
    }

    private static double multipleDe10Sup(double d) {
        return 10.0 + 10.0 * Math.floor(d / 10.0);
    }

    private void tracerFrontieres(Polygon polygon, Color color, int n, Graphics graphics) {
        if (polygon.npoints == 0 || n == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(STYLES_FRONTIERES[n]);
        graphics2D.setColor(color);
        graphics2D.drawPolygon(polygon);
    }

    public void tracerTextesTerritoires(List<Territoire> list, int n, Graphics graphics, int n2, int n3, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
        int n4 = Math.max(n2, n3);
        double d2 = TraceurCarte.rayonCarte(n2, n3, d, pointSphere);
        int n5 = 25;
        int n6 = 11;
        float f = (float)((double)n6 + (double)(n5 - n6) * (d - 1.0) / 25.0);
        Font font = graphics.getFont().deriveFont(1, f);
        Font font2 = graphics.getFont().deriveFont(3, f);
        DonneesIGraphique donneesIGraphique = HistoireMondiale.instance().donneesIGraphique();
        for (Territoire territoire : list) {
            int n7;
            boolean bl;
            TexteCarte texteCarte;
            PointSphere pointSphere2;
            if (!this.proche(territoire.pourtour(), pointSphere, d2) || Chaines.estVide(territoire.nom()) || !(donneesIGraphique.loupeTerritoire(territoire) < d) || !pointSphere.DansLeCercle(pointSphere2 = donneesIGraphique.centreTexteTerritoire(territoire), d2)) continue;
            PointPlan pointPlan = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(pointSphere2, matrice, d, n4), n2, n3);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(Color.BLACK);
            String string = territoire.nom();
            TexteCarte texteCarte2 = new TexteCarte(string.split("\\$"), font);
            TexteTerritoire texteTerritoire = territoire.texteEn(n);
            if (texteTerritoire == null) {
                texteCarte = new TexteCarte();
                bl = false;
            } else {
                String[] stringArray = texteTerritoire.texte().split("&");
                n7 = texteTerritoire.italique();
                texteCarte = new TexteCarte(stringArray, n7 != 0 ? font2 : font);
                bl = n7 == 0 && !stringArray[0].equals("");
            }
            int n8 = (int)pointPlan.y() - TexteCarte.hauteurTextes(texteCarte2, texteCarte, graphics2D) / 2;
            n7 = (int)pointPlan.x() - texteCarte2.largeur(graphics2D) / 2;
            int n9 = n8;
            int n10 = (int)pointPlan.x() - texteCarte.largeur(graphics2D) / 2;
            int n11 = n9 + texteCarte2.hauteur(graphics2D);
            texteCarte2.tracerLignesCentrees(graphics2D, n7, n9, false);
            texteCarte.tracerLignesCentrees(graphics2D, n10, n11, bl);
            int n12 = Math.min(n7, n10);
            int n13 = n8;
            int n14 = Math.max(texteCarte2.largeur(graphics2D), texteCarte.largeur(graphics2D));
            int n15 = n11 + texteCarte.hauteur(graphics2D) - n13;
            Rectangle rectangle = new Rectangle(n12, n13, n14, n15);
            infosTracerImage.nouvImg.textesTerritoiresTraces.put(rectangle, territoire);
        }
    }

    public void tracerMeridiensParalleles(Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        this.tracerMeridiens(graphics, n, n2, d, pointSphere, infosTracerImage);
        this.tracerParalleles(graphics, n, n2, d, pointSphere, infosTracerImage);
    }

    private int determinerPasLongitude(boolean bl, int n, int n2, double d, PointSphere pointSphere) {
        double d2;
        PointSphere pointSphere2;
        if (bl) {
            pointSphere2 = CoordSphere.InvProjection(new PointPlan(n, n2), pointSphere, n, n2, d);
            PointSphere pointSphere3 = CoordSphere.InvProjection(new PointPlan(0.0, n2), pointSphere, n, n2, d);
            d2 = pointSphere2.longitude() - pointSphere3.longitude();
            if (d2 < 0.0) {
                d2 += 360.0;
            }
        } else {
            pointSphere2 = CoordSphere.InvProjection(new PointPlan(0.0, 0.0), pointSphere, n, n2, d);
            PointSphere pointSphere4 = CoordSphere.InvProjection(new PointPlan(n, 0.0), pointSphere, n, n2, d);
            d2 = pointSphere4.longitude() - pointSphere2.longitude();
            if (d2 < 0.0) {
                d2 += 360.0;
            }
        }
        double d3 = (double)n / d2;
        if (d3 > 150.0) {
            return 1;
        }
        if (d3 > 75.0) {
            return 2;
        }
        if (d3 > 30.0) {
            return 5;
        }
        return 10;
    }

    private double[] determinerPasLatitude(int n, int n2, double d, PointSphere pointSphere) {
        PointPlan pointPlan;
        double d2;
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
        int n3 = Math.max(n, n2);
        PointSphere pointSphere2 = CoordSphere.InvProjection(new PointPlan(0.0, 0.0), pointSphere, n, n2, d);
        PointSphere pointSphere3 = CoordSphere.InvProjection(new PointPlan(n / 2, 0.0), pointSphere, n, n2, d);
        PointSphere pointSphere4 = CoordSphere.InvProjection(new PointPlan(0.0, n2), pointSphere, n, n2, d);
        PointSphere pointSphere5 = CoordSphere.InvProjection(new PointPlan(n / 2, n2), pointSphere, n, n2, d);
        double d3 = 0.0;
        double d4 = n2;
        double d5 = pointSphere2.latitude() > pointSphere3.latitude() ? pointSphere2.latitude() : pointSphere3.latitude();
        double d6 = d2 = pointSphere4.latitude() < pointSphere5.latitude() ? pointSphere4.latitude() : pointSphere5.latitude();
        if (pointSphere.latitude() >= 60.0) {
            pointPlan = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(new PointSphere(0.0, 90.0), matrice, d, n3), n, n2);
            if (pointPlan.y() > 0.0) {
                d5 = 90.0;
                d3 = pointPlan.y();
            }
        } else if (pointSphere.latitude() <= -60.0 && (pointPlan = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(new PointSphere(0.0, -90.0), matrice, d, n3), n, n2)).y() < (double)n2) {
            d2 = -90.0;
            d4 = pointPlan.y();
        }
        double d7 = (d4 - d3) / (d5 - d2);
        if (d7 > 150.0) {
            return new double[]{1.0, d5, d2};
        }
        if (d7 > 75.0) {
            return new double[]{2.0, d5, d2};
        }
        if (d7 > 30.0) {
            return new double[]{5.0, d5, d2};
        }
        return new double[]{10.0, d5, d2};
    }

    /*
     * WARNING - void declaration
     */
    private void tracerMeridiens(Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        boolean bl = pointSphere.latitude() >= 0.0;
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        int n3 = this.determinerPasLongitude(bl, n, n2, d, pointSphere);
        double d2 = TraceurCarte.rayonCarte(n, n2, d, pointSphere);
        int n4 = Math.max(n, n2);
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
        for (int i = 180; i > -180; i -= n3) {
            double d3;
            void var23_25;
            Object object2;
            int n5;
            ArrayList<PointSphere> arrayList = new ArrayList<PointSphere>();
            int n6 = 0;
            if (bl) {
                for (n5 = -89; n5 < 89; ++n5) {
                    object2 = new PointSphere(i, n5);
                    if (!pointSphere.DansLeCercle((PointSphere)object2, d2)) continue;
                    n6 = n5;
                    arrayList.add(new PointSphere(i, n6 - 1));
                    arrayList.add((PointSphere)object2);
                    break;
                }
            } else {
                for (n5 = 89; n5 > -89; --n5) {
                    object2 = new PointSphere(i, n5);
                    if (!pointSphere.DansLeCercle((PointSphere)object2, d2)) continue;
                    n6 = n5;
                    arrayList.add(new PointSphere(i, n6 + 1));
                    arrayList.add((PointSphere)object2);
                    break;
                }
            }
            if (arrayList.isEmpty()) continue;
            if (bl) {
                for (n5 = n6 + 1; n5 < 89; ++n5) {
                    object2 = new PointSphere(i, n5);
                    arrayList.add((PointSphere)object2);
                    if (pointSphere.DansLeCercle((PointSphere)object2, d2)) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n5 = n6 - 1; n5 > -89; --n5) {
                    object2 = new PointSphere(i, n5);
                    arrayList.add((PointSphere)object2);
                    if (pointSphere.DansLeCercle((PointSphere)object2, d2)) {
                        continue;
                    }
                    break;
                }
            }
            object2 = null;
            ArrayList<PointPlan> arrayList2 = new ArrayList<PointPlan>();
            for (PointSphere pointSphere2 : arrayList) {
                PointPlan pointPlan;
                boolean bl2 = infosTracerImage != null && infosTracerImage.pointPlanConnu(pointSphere2);
                PointPlan pointPlan2 = pointPlan = bl2 ? infosTracerImage.pointPlan(pointSphere2) : CoordSphere.projection(pointSphere2, matrice, d, n4);
                if (!bl2) {
                    infosTracerImage.nouvImg.cachePoints.put(pointSphere2, pointPlan);
                }
                if (object2 != null && ((PointPlan)object2).confonduCoordEntieres(pointPlan)) continue;
                object2 = pointPlan;
                arrayList2.add(pointPlan);
            }
            if (arrayList2.isEmpty()) continue;
            List<PointPlan> list = CalculsPlan.changementOrigineCentreVersCoinHautGauche(arrayList2, n, n2);
            this.tracerLigneBrisee(list, Color.LIGHT_GRAY, 1, graphics);
            Object var23_24 = null;
            PointPlan pointPlan = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PointPlan pointPlan3 = (PointPlan)iterator.next();
                if (rectangle.contains(pointPlan3.x(), pointPlan3.y())) {
                    pointPlan = pointPlan3;
                    break;
                }
                PointPlan pointPlan4 = pointPlan3;
            }
            if (var23_25 == null || pointPlan == null) continue;
            double d4 = 0.0;
            double d5 = pointPlan.x();
            double d6 = pointPlan.y();
            double d7 = var23_25.x();
            double d8 = var23_25.y();
            if (bl && d8 > (double)n2) {
                d4 = n2 - 10;
            }
            if (!bl && d8 < 0.0) {
                d4 = 10.0;
            }
            if (d7 == d5) {
                d3 = d5;
            } else {
                double d9 = (d8 - d6) / (d7 - d5);
                d3 = d5 + (d4 - d6) / d9;
            }
            if (!(d3 > 0.0) || !(d3 < (double)n)) continue;
            graphics.drawString("" + i, (int)d3, (int)d4);
        }
    }

    private void tracerParalleles(Graphics graphics, int n, int n2, double d, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        boolean bl = pointSphere.latitude() >= 0.0;
        double[] dArray = this.determinerPasLatitude(n, n2, d, pointSphere);
        int n3 = (int)dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        PointSphere pointSphere2 = CoordSphere.InvProjection(new PointPlan(0.0, n2), pointSphere, n, n2, d);
        double d4 = pointSphere2.longitude();
        d2 = d2 == 90.0 ? (double)(90 - n3) : Math.floor(d2 / (double)n3) * (double)n3;
        d3 = d3 == -90.0 ? (double)(-90 + n3) : Math.ceil(d3 / (double)n3) * (double)n3;
        if (bl) {
            int n4 = (int)d3;
            while ((double)n4 <= d2) {
                d4 = this.traiterParallele(n4, d4, graphics, n, n2, d, pointSphere, infosTracerImage);
                n4 += n3;
            }
        } else {
            int n5 = (int)d2;
            while ((double)n5 >= d3) {
                d4 = this.traiterParallele(n5, d4, graphics, n, n2, d, pointSphere, infosTracerImage);
                n5 -= n3;
            }
        }
    }

    private double traiterParallele(int n, double d, Graphics graphics, int n2, int n3, double d2, PointSphere pointSphere, InfosTracerImage infosTracerImage) {
        double d3 = d;
        ArrayList<PointSphere> arrayList = new ArrayList<PointSphere>();
        int n4 = (int)(pointSphere.longitude() - 90.0);
        while ((double)n4 < pointSphere.longitude() + 270.0) {
            arrayList.add(new PointSphere(n4, n));
            ++n4;
        }
        List<List<PointPlan>> list = this.determinerContours(arrayList, n2, n3, d2, pointSphere, infosTracerImage);
        if (!list.isEmpty()) {
            ArrayList<Polygon> arrayList2 = new ArrayList<Polygon>();
            for (List<PointPlan> object : list) {
                arrayList2.add(this.polygonePourTrace(object));
            }
            if (arrayList2 != null) {
                for (Polygon polygon : arrayList2) {
                    this.tracerFrontieres(polygon, Color.lightGray, 1, graphics);
                }
                d3 = this.tracerMarque(list.get(0), d3, graphics, n, n2, n3, pointSphere, d2);
            }
        }
        return d3;
    }

    private double tracerMarque(List<PointPlan> list, double d, Graphics graphics, int n, int n2, int n3, PointSphere pointSphere, double d2) {
        Object object;
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        int n4 = Math.max(n2, n3);
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
        double d3 = d;
        int n5 = -1;
        int n6 = -1;
        double d4 = pointSphere.longitude() - 90.0;
        PointSphere pointSphere2 = new PointSphere(d4, n);
        PointPlan pointPlan = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(pointSphere2, matrice, d2, n4), n2, n3);
        if (!rectangle.contains(pointPlan.x(), pointPlan.y())) {
            object = pointPlan;
            PointPlan pointPlan2 = null;
            for (PointPlan pointPlan3 : list) {
                if (rectangle.contains(pointPlan3.x(), pointPlan3.y())) {
                    pointPlan2 = pointPlan3;
                    break;
                }
                object = pointPlan3;
            }
            if (pointPlan2 != null) {
                double d5 = 0.0;
                double d6 = pointPlan2.x();
                double d7 = pointPlan2.y();
                double d8 = ((PointPlan)object).x();
                double d9 = ((PointPlan)object).y();
                if (d8 != d6) {
                    double d10 = (d9 - d7) / (d8 - d6);
                    double d11 = d7 - d10 * d6;
                    if (d11 > 0.0 && d11 < (double)n3) {
                        n5 = (int)d5;
                        n6 = (int)d11;
                        PointSphere pointSphere3 = CoordSphere.InvProjection(new PointPlan(d5, d11), pointSphere, n2, n3, d2);
                        d3 = pointSphere3.longitude();
                    } else {
                        int n7 = (int)d3;
                        while ((double)n7 != pointSphere.longitude()) {
                            PointSphere pointSphere4;
                            PointPlan pointPlan4;
                            if (n7 == 181) {
                                n7 = -179;
                            }
                            if (rectangle.contains((pointPlan4 = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(pointSphere4 = new PointSphere(n7, n), matrice, d2, n4), n2, n3)).x(), pointPlan4.y())) {
                                n5 = (int)pointPlan4.x();
                                n6 = (int)pointPlan4.y();
                                if (n6 < 10) {
                                    n6 = 10;
                                }
                                if (n6 <= n3 - 10) break;
                                n6 = n3 - 10;
                                break;
                            }
                            ++n7;
                        }
                    }
                } else {
                    System.out.println("Alerte : le segment courant-pr\u00e9c\u00e9dent est parall\u00e8le au bord gauche");
                    System.out.println("ce cas ne devrait jamais arriver");
                }
            }
        } else {
            int n8 = (int)d3;
            while ((double)n8 != pointSphere.longitude()) {
                PointSphere pointSphere5;
                PointPlan pointPlan5;
                if (n8 == 181) {
                    n8 = -179;
                }
                if (rectangle.contains((pointPlan5 = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(pointSphere5 = new PointSphere(n8, n), matrice, d2, n4), n2, n3)).x(), pointPlan5.y())) {
                    n5 = (int)pointPlan5.x();
                    n6 = (int)pointPlan5.y();
                    if (n6 < 10) {
                        n6 = 10;
                    }
                    if (n6 <= n3 - 10) break;
                    n6 = n3 - 10;
                    break;
                }
                ++n8;
            }
        }
        if (n5 > -1) {
            graphics.setColor(Color.magenta);
            object = graphics.getFont();
            graphics.setFont(((Font)object).deriveFont(2));
            graphics.drawString("" + n, n5, n6);
            graphics.setFont((Font)object);
        }
        return d3;
    }

    public static double rayonCarte(int n, int n2, double d, PointSphere pointSphere) {
        PointSphere pointSphere2 = CoordSphere.InvProjection(new PointPlan(0.0, 0.0), pointSphere, n, n2, d);
        return pointSphere.cosArcAB(pointSphere2);
    }

    public boolean proche(Pourtour pourtour, PointSphere pointSphere, double d) {
        PointSphere pointSphere2 = pourtour.centreCercleLimite();
        double d2 = pourtour.cosCercleLimite();
        return pointSphere.voisin(d, pointSphere2, d2);
    }

    public boolean proche(Fleuve fleuve, PointSphere pointSphere, double d) {
        PointSphere pointSphere2 = fleuve.centreCercleLimite();
        double d2 = fleuve.cosCercleLimite();
        return pointSphere.voisin(d, pointSphere2, d2);
    }
}

