/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import fr.histoiremondiale.histoire.DonneesIGraphique;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Fleuve;
import fr.histoiremondiale.histoire.donnees.Mer;
import fr.histoiremondiale.histoire.donnees.Terre;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.tracercartes.DemandeTracerCarte;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosTracerImage;
import fr.histoiremondiale.histoire.igraphique.tracercartes.TraceurCarte;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class GestTracerCartes
implements Runnable {
    private TraceurCarte traceurCarte = new TraceurCarte();
    private PanCarte p_carte;
    private InfosTracerImage infosTraceImgActuelle;
    private BlockingQueue<DemandeTracerCarte> demandesTrace;
    private BufferedImage imgReserve = null;
    private int largeurImgReserve = -1;
    private int hauteurImgReserve = -1;
    private BufferedImage imgReserve2 = null;
    private int largeurImgReserve2 = -1;
    private int hauteurImgReserve2 = -1;

    public static GestTracerCartes creerInstance(PanCarte panCarte) {
        GestTracerCartes gestTracerCartes = new GestTracerCartes(panCarte);
        Thread thread = new Thread(gestTracerCartes);
        thread.setDaemon(true);
        thread.start();
        return gestTracerCartes;
    }

    private GestTracerCartes(PanCarte panCarte) {
        this.p_carte = panCarte;
        this.demandesTrace = new LinkedBlockingQueue<DemandeTracerCarte>();
        this.infosTraceImgActuelle = new InfosTracerImage();
    }

    @Override
    public void run() {
        this.tracerCartesDemandees();
        System.err.println("! Fin du fil d'ex\u00e9cution de trac\u00e9 des cartes");
    }

    public synchronized void demanderNouvelleCarte(int n, boolean bl, boolean bl2, PointSphere pointSphere, int n2, int n3, double d, Color color, Color color2, Color color3) {
        DemandeTracerCarte demandeTracerCarte = new DemandeTracerCarte(n, bl, bl2, pointSphere, n2, n3, d, color, color2, color3);
        this.demandesTrace.clear();
        this.demandesTrace.add(demandeTracerCarte);
    }

    private DemandeTracerCarte prochaineCarteATracer() throws InterruptedException {
        return this.demandesTrace.take();
    }

    public synchronized InfosTracerImage infosImageActuelle() {
        return this.infosTraceImgActuelle;
    }

    private synchronized void modifImageActuelle(InfosTracerImage infosTracerImage) {
        this.infosTraceImgActuelle = infosTracerImage;
        this.infosTraceImgActuelle.terminerTracer();
    }

    private synchronized void imageActuelleEnModification(DemandeTracerCarte demandeTracerCarte) {
        InfosTracerImage infosTracerImage = this.infosImageActuelle();
        if (infosTracerImage.imageDisponible()) {
            if (!demandeTracerCarte.equals(infosTracerImage.ancImg.demande)) {
                infosTracerImage.ancImg.perimee = true;
            }
            this.p_carte.repaint();
        }
    }

    private void tracerCartesDemandees() {
        block6: while (true) {
            try {
                while (true) {
                    DemandeTracerCarte demandeTracerCarte;
                    try {
                        demandeTracerCarte = this.prochaineCarteATracer();
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("! Tracer des cartes : demande d'interruption du fil d'ex\u00e9cution");
                        break block6;
                    }
                    InfosTracerImage infosTracerImage = this.infosTraceImgActuelle;
                    DemandeTracerCarte demandeTracerCarte2 = infosTracerImage.ancImg.demande;
                    DonneesIGraphique donneesIGraphique = HistoireMondiale.instance().donneesIGraphique();
                    boolean bl = donneesIGraphique.donneesTraceCarteModifiees();
                    if (demandeTracerCarte.largeurCarte <= 0 || demandeTracerCarte.hauteurCarte <= 0 || demandeTracerCarte.equals(demandeTracerCarte2) && !bl) continue;
                    this.imageActuelleEnModification(demandeTracerCarte);
                    BufferedImage bufferedImage = demandeTracerCarte.largeurCarte == this.largeurImgReserve && demandeTracerCarte.hauteurCarte == this.hauteurImgReserve ? this.imgReserve : new BufferedImage(demandeTracerCarte.largeurCarte, demandeTracerCarte.hauteurCarte, 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    if (demandeTracerCarte2 == null || demandeTracerCarte2.largeurCarte != demandeTracerCarte.largeurCarte || demandeTracerCarte2.hauteurCarte != demandeTracerCarte.hauteurCarte || demandeTracerCarte2.loupe != demandeTracerCarte.loupe || !demandeTracerCarte2.ptCentrePlan.equals(demandeTracerCarte.ptCentrePlan)) {
                        infosTracerImage = new InfosTracerImage();
                    } else {
                        infosTracerImage.nouvImg.cachePoints = infosTracerImage.ancImg.cachePoints;
                        if (demandeTracerCarte2.annee == demandeTracerCarte.annee) {
                            infosTracerImage.nouvImg.multiPolygonesPourtoursTraces = infosTracerImage.ancImg.multiPolygonesPourtoursTraces;
                            infosTracerImage.nouvImg.territoiresTraces = infosTracerImage.ancImg.territoiresTraces;
                        }
                        if (demandeTracerCarte.equals(demandeTracerCarte2)) {
                            infosTracerImage.nouvImg.imgCompleteSansTextes = infosTracerImage.ancImg.imgCompleteSansTextes;
                        }
                    }
                    infosTracerImage.nouvImg.demande = demandeTracerCarte;
                    List<Terre> list = HistoireMondiale.instance().carte().terres();
                    List<Mer> list2 = HistoireMondiale.instance().carte().mers();
                    List<Fleuve> list3 = HistoireMondiale.instance().carte().fleuves();
                    List<Territoire> list4 = HistoireMondiale.instance().donneesHisto().territoiresAnnee(demandeTracerCarte.annee);
                    this.traceurCarte.tracerCarte(list, list2, list3, list4, demandeTracerCarte.annee, demandeTracerCarte.fleuvesAffiches, demandeTracerCarte.meridiensParallelesAffiches, demandeTracerCarte.ptCentrePlan, demandeTracerCarte.largeurCarte, demandeTracerCarte.hauteurCarte, demandeTracerCarte.loupe, demandeTracerCarte.coulMers, demandeTracerCarte.coulTerres, demandeTracerCarte.coulFleuves, graphics, infosTracerImage);
                    infosTracerImage.nouvImg.demande = demandeTracerCarte;
                    infosTracerImage.nouvImg.image = bufferedImage;
                    this.modifImageActuelle(infosTracerImage);
                    graphics.dispose();
                    this.p_carte.repaint();
                    this.imgReserve = this.imgReserve2;
                    this.largeurImgReserve = this.largeurImgReserve2;
                    this.hauteurImgReserve = this.hauteurImgReserve2;
                    this.imgReserve2 = bufferedImage;
                    this.largeurImgReserve2 = demandeTracerCarte.largeurCarte;
                    this.hauteurImgReserve2 = demandeTracerCarte.hauteurCarte;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Erreur lors du tracer d'une carte");
                throwable.printStackTrace();
                try {
                    this.infosTraceImgActuelle.ancImg.erreur = throwable;
                    this.p_carte.repaint();
                }
                catch (Throwable throwable2) {}
                continue;
            }
            break;
        }
    }
}

