/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import fr.histoiremondiale.histoire.utiles.igraphique.swing.Messages;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextFieldNumerique
extends JTextField {
    boolean relatif = false;
    boolean valeursEncadrees = false;
    List<Point> valeursAutorisees = new ArrayList<Point>();

    public TextFieldNumerique() {
        this.setDocument(new DocumentNumerique());
        this.setHorizontalAlignment(4);
    }

    public TextFieldNumerique(int n) {
        this();
        this.setText("" + n);
    }

    public TextFieldNumerique(boolean bl) {
        this();
        this.relatif = bl;
    }

    public TextFieldNumerique(int n, boolean bl) {
        this();
        this.relatif = bl;
        this.setText("" + n);
    }

    public TextFieldNumerique(int n, boolean bl, int n2, int n3) {
        this();
        if (n2 > n3) {
            throw new RuntimeException("la valeur mini (" + n2 + ") doit \u00eatre inf\u00e9rieure \u00e0 la valeur maxi (" + n3 + ")");
        }
        this.valeursAutorisees.add(new Point(n2, n3));
        this.valeursEncadrees = true;
        this.relatif = bl;
        this.setText("" + n);
    }

    public void setRelatif(boolean bl) {
        this.relatif = bl;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(600, 100);
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("entrer des chiffres");
        TextFieldNumerique textFieldNumerique = new TextFieldNumerique(-1800, true);
        textFieldNumerique.addValeursAutorisees(-3100, -1);
        textFieldNumerique.addValeursAutorisees(1, 2000);
        textFieldNumerique.setHorizontalAlignment(4);
        textFieldNumerique.setColumns(4);
        jPanel.add(jLabel);
        jPanel.add(textFieldNumerique);
        jFrame.getContentPane().add(jPanel);
        jFrame.setVisible(true);
    }

    public void addValeursAutorisees(int n, int n2) {
        if (n > n2) {
            throw new RuntimeException("la valeur mini (" + n + ") doit \u00eatre inf\u00e9rieure \u00e0 la valeur maxi (" + n2 + ")");
        }
        this.valeursAutorisees.add(new Point(n, n2));
        this.valeursEncadrees = true;
    }

    public String numerique(int n, String string) {
        if (string.isEmpty()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        String string2 = "";
        if (this.relatif && n == 0 && cArray[0] == '-') {
            string2 = "-";
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!Character.isDigit(c)) continue;
            string2 = string2 + c;
        }
        return string2;
    }

    public void setValue(int n) {
        this.setText("" + n);
    }

    class DocumentNumerique
    extends PlainDocument {
        DocumentNumerique() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (string.isEmpty()) {
                return;
            }
            String string2 = this.getText(0, this.getLength());
            if (n == 0 && string2.startsWith("-")) {
                return;
            }
            String string3 = TextFieldNumerique.this.numerique(n, string);
            if (string3.isEmpty()) {
                return;
            }
            String string4 = "";
            char[] cArray = string2.toCharArray();
            char[] cArray2 = string3.toCharArray();
            for (n2 = 0; n2 < n; ++n2) {
                string4 = string4 + cArray[n2];
            }
            for (n2 = 0; n2 < cArray2.length; ++n2) {
                string4 = string4 + cArray2[n2];
            }
            for (n2 = n; n2 < cArray.length; ++n2) {
                string4 = string4 + cArray[n2];
            }
            n2 = string4.equals("-") ? 1 : 0;
            if (n2 == 0) {
                int n3 = Integer.parseInt(string4);
                if (TextFieldNumerique.this.valeursEncadrees) {
                    for (Point point : TextFieldNumerique.this.valeursAutorisees) {
                        if (point.x > n3 || n3 > point.y) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        Messages.messageInfo("Les valeurs autoris\u00e9es se trouvent dans la liste d'intervalles " + this.chaine(TextFieldNumerique.this.valeursAutorisees));
                        return;
                    }
                } else {
                    n2 = 1;
                }
            }
            if (n2 != 0) {
                super.insertString(n, string3, attributeSet);
            }
        }

        private String chaine(List<Point> list) {
            String string = "(";
            for (Point point : list) {
                string = string + ",[" + point.x + " \u00e0 " + point.y + "]";
            }
            string = string.replace("(,", "(") + ")";
            return string;
        }
    }
}

