/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import fr.histoiremondiale.histoire.utiles.exttypes.Flottants;
import fr.histoiremondiale.histoire.utiles.math.PlagesNombres;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Barre
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener,
FocusListener {
    private double mini;
    private double maxi;
    private double valeur;
    private double reference;
    private int largeur = 60;
    private int hauteur = 300;
    private int largeurParDefaut = 60;
    private int hauteurParDefaut = 300;
    private JFormattedTextField texte;
    private int xHautGauche;
    private int yHautGauche;
    private int yBasDroite;
    private int xBasDroite;
    private int hauteurBarre;
    private static final int LARGEUR_BARRE = 10;
    private static final int MARGE_HAUT = 10;
    private static final Color BLANC = MetalLookAndFeel.getWhite();
    private static final Color SOMBRE = MetalLookAndFeel.getPrimaryControlDarkShadow();
    private static final Color FOND = new Color(238, 238, 238);

    public Barre(double d, double d2, double d3) {
        this(d, d2, d3, d3);
    }

    public Barre(double d, double d2, double d3, double d4) {
        if (d > d2) {
            throw new IllegalArgumentException("La valeur minimale devrait \u00eatre inf\u00e9rieure \u00e0 la valeur maximale.");
        }
        this.mini = d;
        this.maxi = d2;
        this.valeur = this.valeurFormatee(PlagesNombres.dansPlage(d3, d, d2));
        this.reference = this.valeurFormatee(PlagesNombres.dansPlage(d4, d, d2));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(Color.LIGHT_GRAY);
        this.setLayout(new BorderLayout());
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        this.texte = new JFormattedTextField(decimalFormat);
        this.texte.setHorizontalAlignment(0);
        this.texte.setValue(d3);
        this.texte.setEditable(false);
        this.texte.getCaret().setVisible(false);
        this.add((Component)this.texte, "South");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.texte.addActionListener(this);
        this.texte.addMouseListener(this);
        this.texte.addFocusListener(this);
    }

    public double reference() {
        return this.reference;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.largeurParDefaut, this.hauteurParDefaut);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(FOND);
        graphics2D.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
        this.hauteurBarre = this.getHeight() - 20 - this.texte.getHeight();
        this.xHautGauche = (this.getWidth() - 10) / 2;
        this.yHautGauche = 10;
        this.yBasDroite = this.yHautGauche + this.hauteurBarre;
        this.xBasDroite = this.xHautGauche + 10;
        int n = (int)((double)this.hauteurBarre * (this.maxi - this.valeur) / (this.maxi - this.mini));
        int n2 = (int)((double)this.hauteurBarre * (this.maxi - this.reference) / (this.maxi - this.mini));
        graphics2D.setColor(SOMBRE);
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.xHautGauche, this.yHautGauche, 10.0f, this.hauteurBarre);
        graphics2D.draw(float_);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(this.xHautGauche + 1, this.yHautGauche + n, 8.0f, this.hauteurBarre - n);
        graphics2D.setPaint(new GradientPaint(this.xHautGauche + 1, this.yBasDroite + n, BLANC, this.xBasDroite - 1, this.yBasDroite + n, SOMBRE));
        graphics2D.fill(float_2);
        Rectangle2D.Float float_3 = new Rectangle2D.Float(this.xHautGauche + 1, this.yHautGauche + 1, 8.0f, n - 1);
        graphics2D.setPaint(new GradientPaint(this.xHautGauche + 1, this.yHautGauche + 1, SOMBRE, this.xBasDroite - 1, this.yHautGauche + 1, BLANC));
        graphics2D.fill(float_3);
        graphics2D.setColor(SOMBRE);
        graphics2D.fill3DRect(this.xHautGauche - 5, this.yHautGauche + n2 - 1, 20, 3, true);
    }

    public void setValeur(double d) {
        double d2 = this.valeurFormatee(PlagesNombres.dansPlage(d, this.mini, this.maxi));
        if (d2 != this.valeur) {
            this.valeur = d2;
            this.repaint();
            this.texte.setValue(d2);
            this.fireValeurChangee(new ChangeEvent(this));
        }
    }

    public void setReference(double d) {
        double d2;
        this.reference = d2 = this.valeurFormatee(PlagesNombres.dansPlage(d, this.mini, this.maxi));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.setValeur(this.maxi - (double)(mouseEvent.getY() - this.yHautGauche) * (this.maxi - this.mini) / (double)this.hauteurBarre);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setValeur(Double.parseDouble(this.texte.getText().replace(',', '.')));
        this.texte.setEditable(false);
        this.texte.getCaret().setVisible(false);
        this.texte.setBorder(new EtchedBorder(1));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.texte.setEditable(mouseEvent.getSource() == this.texte);
        this.texte.getCaret().setVisible(this.texte.isEditable());
        EtchedBorder etchedBorder = new EtchedBorder(this.texte.isEditable() ? 0 : 1);
        this.texte.setBorder(etchedBorder);
        if (!this.texte.isEditable()) {
            this.setValeur(this.maxi - (double)(mouseEvent.getY() - this.yHautGauche) * (this.maxi - this.mini) / (double)this.hauteurBarre);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public double getValeur() {
        return this.valeur;
    }

    protected void fireValeurChangee(ChangeEvent changeEvent) {
        for (ChangeListener changeListener : this.getChangeValeurListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private ChangeListener[] getChangeValeurListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.texte) {
            this.setValeur(Double.parseDouble(this.texte.getText().replace(',', '.')));
            this.texte.setEditable(false);
            this.texte.getCaret().setVisible(false);
            this.texte.setBorder(new EtchedBorder(1));
        }
    }

    private double valeurFormatee(double d) {
        return Flottants.arrondir(d, 2);
    }

    @Override
    public String toString() {
        return "Barre : mini = " + this.mini + " ; maxi = " + this.maxi + " ; valeur = " + this.valeur + " ; r\u00e9f\u00e9rence = " + this.reference;
    }

    public void setLargeur(int n) {
        this.setPreferredSize(n, this.hauteur);
    }

    public void setHauteur(int n) {
        this.setPreferredSize(this.largeur, n);
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
        this.largeur = n;
        this.hauteur = n2;
    }
}

