/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire;

import fr.histoiremondiale.histoire.ConfigAppli;
import fr.histoiremondiale.histoire.DonneesGeographiques;
import fr.histoiremondiale.histoire.DonneesHistoriques;
import fr.histoiremondiale.histoire.DonneesIGraphique;
import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.igraphique.DialAnnee;
import fr.histoiremondiale.histoire.igraphique.DialCentre;
import fr.histoiremondiale.histoire.igraphique.DialCivilisations;
import fr.histoiremondiale.histoire.igraphique.DialLoupe;
import fr.histoiremondiale.histoire.igraphique.FenPrincipale;
import fr.histoiremondiale.histoire.igraphique.evenements.GestEvenementsHistoireMondiale;
import fr.histoiremondiale.histoire.stockage.AccesDonneesConfiguration;
import fr.histoiremondiale.histoire.stockage.AccesDonneesGeographiques;
import fr.histoiremondiale.histoire.stockage.AccesDonneesHistoriques;
import fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique;
import fr.histoiremondiale.histoire.utiles.exceptions.ExceptionConnexionBaseDonnees;
import fr.histoiremondiale.histoire.utiles.exceptions.Exceptions;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class HistoireMondiale {
    public static final String NUMERO_VERSION = "2.1";
    public static final String LICENCE_CODE_SOURCE = "AGPLv3";
    public static final String LIEN_PAGE_LICENCE_CODE_SOURCE = "http://www.gnu.org/licenses/translations.html";
    public static final String DATES_DROITS_COPIE_CODE_SOURCE = "2010-2020";
    public static final String LICENCE_DONNEES = "Creative Commons Attribution Partage dans les m\u00eames conditions (CC-by-sa)";
    public static final String LIEN_PAGE_LICENCE_DONNEES = "http://creativecommons.org/licenses/by-sa/3.0/deed.fr";
    public static final String DATES_DROITS_COPIE_DONNEES = "2010-2020";
    public static final String LICENCE_ICONES = "Licence Art Libre";
    public static final String LIEN_PAGE_LICENCE_ICONES = "http://artlibre.org/licence/lal";
    public static final String DATES_DROITS_COPIE_ICONES = "2011-2020";
    public static final String URL_SITE_WEB = "http://histoiremondiale.net/";
    public static final String URL_PROJET = "http://sourceforge.net/projects/histmondiale/";
    public static final String ADRESSE_CONTACT_HISTOIRE = "histoire.mondiale@gmail.com";
    private static HistoireMondiale instance;
    private ConfigAppli config;
    private EtatAppli etat;
    private DonneesGeographiques carte;
    private DonneesHistoriques donneesHisto;
    private DonneesIGraphique donneesIGraphique;
    private GestEvenementsHistoireMondiale gestEvenements;
    private FenPrincipale fenPrincipale;
    private DialCivilisations dialCivilisations;
    private DialLoupe dialLoupe;
    private DialAnnee dialAnnee;
    private DialCentre dialCentre;

    public static synchronized HistoireMondiale instance() {
        if (instance == null) {
            try {
                instance = new HistoireMondiale();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Erreur lors de la cr\u00e9ation de l'application", throwable);
            }
        }
        return instance;
    }

    private HistoireMondiale() {
        AccesDonneesConfiguration accesDonneesConfiguration;
        System.out.println("Initialisation du programme");
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        try {
            accesDonneesConfiguration = new AccesDonneesConfiguration();
            this.config = accesDonneesConfiguration.chargerConfigGenerale();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Erreur lors du chargement de la configuration g\u00e9n\u00e9rale de l'application.\nVous pouvez essayer de d\u00e9truire le fichier de configuration g\u00e9n\u00e9rale (vos modifications seront perdues).", throwable);
        }
        long l3 = System.currentTimeMillis();
        System.out.println("\tfin du chargement de l'acc\u00e8s \u00e0 la configuration en : " + (l3 - l2) + " ms");
        l2 = System.currentTimeMillis();
        File file = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            String string = this.config.chemRepDonnees() + File.separatorChar + "histoire" + File.separatorChar + "ec.TTF";
            file = new File(string);
            graphicsEnvironment.registerFont(Font.createFont(0, file));
        }
        catch (FontFormatException | IOException exception) {
            throw new RuntimeException("Erreur lors du chargement de la fonte \u00e9colier (ec.TTF).\nElle devrait se trouver dans le r\u00e9pertoire " + this.config.chemRepDonnees() + ".", exception);
        }
        l3 = System.currentTimeMillis();
        System.out.println("\tfin du chargement de la fonte \u00e9colier : " + (l3 - l2) + " ms");
        try {
            l2 = System.currentTimeMillis();
            this.carte = new DonneesGeographiques(new AccesDonneesGeographiques(this.config.chemRepDonnees()));
            l3 = System.currentTimeMillis();
            System.out.println("\tfin de l'initialisation des donn\u00e9es g\u00e9ographiques en : " + (l3 - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.donneesHisto = new DonneesHistoriques(new AccesDonneesHistoriques(this.config.chemRepDonnees()), this.carte.indexLimes());
            l3 = System.currentTimeMillis();
            System.out.println("\tfin de l'initialisation des donn\u00e9es historiques en : " + (l3 - l2) + " ms");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Erreur lors du chargement des donn\u00e9es g\u00e9ographiques et historiques.", throwable);
        }
        l2 = System.currentTimeMillis();
        try {
            this.donneesIGraphique = new DonneesIGraphique(new AccesDonneesIGraphique(this.config.chemRepDonnees(), this.config.chemRepIcones()), this.donneesHisto());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Erreur lors du chargement des donn\u00e9es pour l'interface graphique.", throwable);
        }
        l3 = System.currentTimeMillis();
        System.out.println("\tfin de l'initialisation des donn\u00e9es de l'interface graphique en : " + (l3 - l2) + " ms");
        l2 = System.currentTimeMillis();
        try {
            this.etat = accesDonneesConfiguration.chargerEtatAppli(this.donneesHisto);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Erreur lors du chargement de l'\u00e9tat de l'application.\nVous pouvez essayer de d\u00e9truire le fichier de configuration g\u00e9n\u00e9rale (vos modifications seront perdues).", throwable);
        }
        l3 = System.currentTimeMillis();
        System.out.println("Fin de l'initialisation du programme en : " + (l3 - l) + " ms.");
    }

    public GestEvenementsHistoireMondiale gestEvenements() {
        if (this.gestEvenements == null) {
            throw new IllegalStateException("Le gestionnaire d'\u00e9v\u00e9nements n'est pas initialis\u00e9");
        }
        return this.gestEvenements;
    }

    public void afficherInterface() throws Exception {
        long l;
        System.out.println("Affichage de l'interface");
        long l2 = System.currentTimeMillis();
        if (this.fenPrincipale == null) {
            long l3 = System.currentTimeMillis();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HistoireMondiale.this.fenPrincipale = new FenPrincipale();
                    HistoireMondiale.this.fenPrincipale.setVisible(true);
                }
            });
            l = System.currentTimeMillis();
            System.out.println("\tl'interface graphique est construite et rendue visible en : " + (l - l3) + " ms.");
            l3 = System.currentTimeMillis();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gestEvenements = new GestEvenementsHistoireMondiale();
            l = System.currentTimeMillis();
            System.out.println("\tle gestionnaire des \u00e9v\u00e8nements est construit en : " + (l - l3) + " ms.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoireMondiale.this.fenPrincipale.finirInitialisation();
                    HistoireMondiale.this.gestEvenements().declarerCapturesEvenementsFenPrincipale(HistoireMondiale.this.fenPrincipale);
                }
            });
            l = System.currentTimeMillis();
        } else {
            this.fenPrincipale.setVisible(true);
        }
        l = System.currentTimeMillis();
        System.out.println("fin de l'affichage de l'interface en : " + (l - l2) + " ms.");
    }

    public ConfigAppli config() {
        return this.config;
    }

    public EtatAppli etat() {
        return this.etat;
    }

    public DonneesGeographiques carte() {
        return this.carte;
    }

    public DonneesHistoriques donneesHisto() {
        return this.donneesHisto;
    }

    public DonneesIGraphique donneesIGraphique() {
        return this.donneesIGraphique;
    }

    public FenPrincipale fenPrincipale() {
        return this.fenPrincipale;
    }

    public DialCivilisations dialCivilisations() {
        if (this.dialCivilisations == null) {
            this.dialCivilisations = new DialCivilisations(this.fenPrincipale);
        }
        return this.dialCivilisations;
    }

    public DialLoupe dialLoupe() {
        if (this.dialLoupe == null) {
            this.dialLoupe = new DialLoupe(this.fenPrincipale, "Loupe", 1.0, 25.0);
            this.gestEvenements().declarerCapturesEvenementsDialLoupe(this.dialLoupe);
        }
        return this.dialLoupe;
    }

    public DialAnnee dialAnnee() {
        if (this.dialAnnee == null) {
            this.dialAnnee = new DialAnnee(this.fenPrincipale);
            this.gestEvenements().declarerCapturesEvenementsDialAnnee(this.dialAnnee);
        }
        return this.dialAnnee;
    }

    public DialCentre dialCentre() {
        if (this.dialCentre == null) {
            this.dialCentre = new DialCentre((JFrame)this.fenPrincipale, "Centre");
            this.gestEvenements().declarerCapturesEvenementsDialCentre(this.dialCentre);
        }
        return this.dialCentre;
    }

    public static void main(String[] stringArray) {
        try {
            HistoireMondiale histoireMondiale = HistoireMondiale.instance();
            histoireMondiale.afficherInterface();
        }
        catch (ExceptionConnexionBaseDonnees exceptionConnexionBaseDonnees) {
            exceptionConnexionBaseDonnees.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erreur de connexion \u00e0 la base de donn\u00e9es. V\u00e9rifiez que la base n'est pas en cours d'utilisation (par exemple que le logiciel n'est pas d\u00e9j\u00e0 lanc\u00e9) : \n" + Exceptions.extraireMessagesErreur(exceptionConnexionBaseDonnees), "Erreur lors du lancement de l'application", 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erreur lors du lancement de l'application.\nN'h\u00e9sitez pas \u00e0 contacter les auteurs : histoire.mondiale@gmail.com\n\nErreur : \n" + Exceptions.extraireMessagesErreur(throwable), "Erreur lors du lancement de l'application.", 0);
        }
    }
}

