/*
 * Decompiled with CFR 0.152.
 */
package memory.lecteur;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.PropertiesContainer;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import memory.lecteur.LecteurEventLauncher;
import memory.lecteur.LecteurException;
import memory.lecteur.LecteurListener;
import memory.outils.Messages;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class LecteurMP3
implements Runnable {
    private static final int UNKNOWN = -1;
    private static final int PLAYING = 0;
    private static final int PAUSED = 1;
    private static final int STOPPED = 2;
    private static final int SEEKING = 4;
    private static final int OPENED = 3;
    private static int EXTERNAL_BUFFER_SIZE = 16000;
    private static MpegAudioFileReader mafr = new MpegAudioFileReader();
    private File source = null;
    private Thread thread = null;
    private AudioInputStream encodedAudioInputStream;
    private int nbBytes = -1;
    private AudioInputStream audioInputStream;
    private AudioFileFormat audioFileFormat;
    private SourceDataLine sortieSon;
    protected FloatControl controleVolume;
    private int etat = -1;
    private Collection<LecteurListener> listeners = new ArrayList<LecteurListener>();
    private int nbByteSkip = -1;

    public LecteurMP3() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        this.etat = -1;
        if (this.audioInputStream != null) {
            AudioInputStream audioInputStream = this.audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
        }
        this.audioInputStream = null;
        this.audioFileFormat = null;
        this.encodedAudioInputStream = null;
        this.nbBytes = -1;
        if (this.sortieSon != null) {
            this.sortieSon.stop();
            this.sortieSon.close();
            this.sortieSon = null;
        }
        this.controleVolume = null;
    }

    protected void initAudioInputStream() throws LecteurException {
        try {
            this.reset();
            this.notifyEvent(0);
            this.initAudioInputStream(this.source);
            this.createLine();
            Map proprietesMP3 = null;
            if (!(this.audioFileFormat instanceof TAudioFileFormat)) {
                throw new LecteurException(this.source + " n'est pas un fichier mp3");
            }
            proprietesMP3 = ((TAudioFileFormat)this.audioFileFormat).properties();
            this.nbBytes = this.audioFileFormat.getByteLength();
            Long duree = (Long)proprietesMP3.get("duration");
            for (LecteurListener listener : this.listeners) {
                listener.opened(duree);
            }
            this.etat = 3;
            this.notifyEvent(1);
        }
        catch (LineUnavailableException e) {
            throw new LecteurException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new LecteurException(e);
        }
        catch (IOException e) {
            throw new LecteurException(e);
        }
    }

    protected void initAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.audioInputStream = AudioSystem.getAudioInputStream(url);
        this.audioFileFormat = AudioSystem.getAudioFileFormat(url);
    }

    private void closeStream() {
        try {
            if (this.audioInputStream != null) {
                this.audioInputStream.close();
            }
        }
        catch (IOException e) {
            Messages.messageErreur("erreur sur la fermeture du flux", e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPlayback() {
        if (this.etat == 0 || this.etat == 1) {
            if (this.sortieSon != null) {
                this.sortieSon.flush();
                this.sortieSon.stop();
            }
            this.etat = 2;
            this.notifyEvent(3);
            AudioInputStream audioInputStream = this.audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
        }
    }

    private void pausePlayback() {
        if (this.sortieSon != null && this.etat == 0) {
            this.sortieSon.flush();
            this.sortieSon.stop();
            this.etat = 1;
            this.notifyEvent(4);
        }
    }

    private void resumePlayback() {
        if (this.sortieSon != null && this.etat == 1) {
            this.sortieSon.start();
            this.etat = 0;
            this.notifyEvent(5);
        }
    }

    private void startPlayback() throws LecteurException {
        if (this.etat == 2) {
            this.initAudioInputStream();
        }
        if (this.etat == 3) {
            if (this.thread != null && this.thread.isAlive()) {
                int cnt = 0;
                while (this.etat != 3) {
                    try {
                        if (this.thread == null) continue;
                        Thread.sleep(1000L);
                        if (++cnt <= 2) continue;
                        this.thread.interrupt();
                    }
                    catch (InterruptedException e) {
                        throw new LecteurException("d\u00e9lai d'attente trop long (erreur)", e);
                    }
                }
            }
            try {
                this.initLine();
            }
            catch (LineUnavailableException e) {
                throw new LecteurException("impossible d'initialiser la sortie son", e);
            }
            this.thread = new Thread((Runnable)this, "LecteurMP3");
            this.thread.start();
            if (this.sortieSon != null) {
                this.sortieSon.start();
                this.etat = 0;
                this.notifyEvent(2);
            }
        }
    }

    private void initLine() throws LineUnavailableException {
        if (this.sortieSon == null) {
            this.createLine();
        }
        if (!this.sortieSon.isOpen()) {
            this.openLine();
        } else {
            AudioFormat audioInputStreamFormat;
            AudioFormat lineAudioFormat = this.sortieSon.getFormat();
            AudioFormat audioFormat = audioInputStreamFormat = this.audioInputStream == null ? null : this.audioInputStream.getFormat();
            if (!lineAudioFormat.equals(audioInputStreamFormat)) {
                this.sortieSon.close();
                this.openLine();
            }
        }
    }

    private void createLine() throws LineUnavailableException {
        if (this.sortieSon == null) {
            AudioFormat sourceFormat = this.audioInputStream.getFormat();
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), 2 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), false);
            this.encodedAudioInputStream = this.audioInputStream;
            this.audioInputStream = AudioSystem.getAudioInputStream(targetFormat, this.audioInputStream);
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
            this.sortieSon = (SourceDataLine)AudioSystem.getLine(info);
        }
    }

    private void openLine() throws LineUnavailableException {
        if (this.sortieSon != null) {
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            int buffersize = this.sortieSon.getBufferSize();
            this.sortieSon.open(audioFormat, buffersize);
            if (this.sortieSon.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.controleVolume = (FloatControl)this.sortieSon.getControl(FloatControl.Type.MASTER_GAIN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int nBytesRead = 1;
        byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
        AudioInputStream audioInputStream = this.audioInputStream;
        synchronized (audioInputStream) {
            block8: while (true) {
                if (nBytesRead == -1 || this.etat == 2 || this.etat == -1) {
                    if (this.sortieSon != null) {
                        this.sortieSon.drain();
                        this.sortieSon.stop();
                        this.sortieSon.close();
                        this.sortieSon = null;
                    }
                    if (nBytesRead == -1) {
                        this.notifyEvent(8);
                    }
                    this.closeStream();
                    break;
                }
                if (this.etat == 0) {
                    try {
                        if (this.nbByteSkip > 0) {
                            this.audioInputStream.skip(this.nbByteSkip);
                            this.nbByteSkip = 0;
                        }
                        if ((nBytesRead = this.audioInputStream.read(abData, 0, abData.length)) < 0) continue;
                        byte[] pcm = new byte[nBytesRead];
                        System.arraycopy(abData, 0, pcm, 0, nBytesRead);
                        this.sortieSon.write(abData, 0, nBytesRead);
                        Iterator<LecteurListener> it = this.listeners.iterator();
                        while (true) {
                            if (!it.hasNext()) continue block8;
                            LecteurListener listener = it.next();
                            if (!(this.audioInputStream instanceof PropertiesContainer)) {
                                throw new LecteurException("impossible d'obtenir la progression de la lecture");
                            }
                            Map proprietes = ((PropertiesContainer)((Object)this.audioInputStream)).properties();
                            long y = (Long)proprietes.get("mp3.position.microseconds");
                            listener.progress(y);
                        }
                    }
                    catch (IOException e) {
                        this.etat = 2;
                        this.notifyEvent(3);
                        e.printStackTrace();
                    }
                    catch (LecteurException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.etat = 2;
        this.notifyEvent(3);
    }

    protected String etatEnChaine() {
        switch (this.etat) {
            case -1: {
                return "inconnu";
            }
            case 0: {
                return "en lecture";
            }
            case 1: {
                return "en pause";
            }
            case 2: {
                return "\u00e0 l'arr\u00eat";
            }
            case 4: {
                return "saut";
            }
            case 3: {
                return "ouvert";
            }
        }
        return "cas non pr\u00e9vu";
    }

    protected void notifyEvent(int code) {
        LecteurEventLauncher trigger = new LecteurEventLauncher(code, new ArrayList<LecteurListener>(this.listeners));
        trigger.start();
    }

    protected int getEncodedStreamPosition() {
        int nEncodedBytes = -1;
        try {
            if (this.encodedAudioInputStream != null) {
                nEncodedBytes = this.nbBytes - this.encodedAudioInputStream.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return nEncodedBytes;
    }

    public boolean hasGainControl() {
        if (this.controleVolume == null && this.sortieSon != null && this.sortieSon.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.controleVolume = (FloatControl)this.sortieSon.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return this.controleVolume != null;
    }

    public float getGainValue() {
        if (this.hasGainControl()) {
            return this.controleVolume.getValue();
        }
        return 0.0f;
    }

    public float getMaximumGain() {
        if (this.hasGainControl()) {
            return this.controleVolume.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimumGain() {
        if (this.hasGainControl()) {
            return this.controleVolume.getMinimum();
        }
        return 0.0f;
    }

    public void play() throws LecteurException {
        this.startPlayback();
    }

    public void stop() {
        this.stopPlayback();
    }

    public void pause() {
        this.pausePlayback();
    }

    public void resume() {
        this.resumePlayback();
    }

    public void setGain(double fGain) throws LecteurException {
        if (!this.hasGainControl()) {
            throw new LecteurException("contr\u00f4le du volume non support\u00e9");
        }
        double minGainDB = this.getMinimumGain();
        double ampGainDB = (double)(0.5f * this.getMaximumGain()) - minGainDB;
        double cste = Math.log(10.0) / 20.0;
        double valueDB = minGainDB + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * fGain);
        this.controleVolume.setValue((float)valueDB);
        this.notifyEvent(10);
    }

    protected void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.audioInputStream = mafr.getAudioInputStream(file);
        this.audioFileFormat = mafr.getAudioFileFormat(file);
    }

    public void skip(double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("param\u00e8tre ill\u00e9gal : x (" + x + ") devrait \u00eatre entre 0 et 1");
        }
        this.nbByteSkip = (int)(x * (double)this.nbBytes);
    }

    public void addLecteurListener(LecteurListener bpl) {
        this.listeners.add(bpl);
    }

    public void open(File file) throws LecteurException {
        if (file != null) {
            this.source = file;
            this.initAudioInputStream();
        }
    }

    public static void main(String[] args) {
        LecteurMP3 lecteur = new LecteurMP3();
        File file = new File("chants\\merle noir.mp3");
        try {
            lecteur.open(file);
            lecteur.skip(0.9);
            lecteur.play();
        }
        catch (LecteurException e) {
            e.printStackTrace();
        }
    }
}

