/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import memory.chants.GestionDonnees;
import memory.chants.JDialogChoixLangue;
import memory.chants.JDialogGalerie;
import memory.chants.JDialogSonotheque;
import memory.chants.JDialogTexteInformatif;
import memory.chants.JLecteurMP3;
import memory.chants.Oiseau;

public class Fenetre
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -9203465609173866259L;
    private GestionDonnees gd;
    private int bonneReponseBoutons;
    private int bonneReponseOiseau;
    private int nbBonnesReponses;
    private int nbQuestions;
    private int nbBoutons = 10;
    private JPanel gauche;
    private JPanel bas;
    private JPanel centre;
    private Box droite;
    private Box fenetre;
    private JLecteurMP3 lecteur;
    private JButton[] boutons;
    private JButton btnPlay;
    private JButton btnStop;
    private JButton btnLangue;
    private JButton btnAide;
    private JButton btnSonotheque;
    private JButton btnGalerie;
    private JButton btnAPropos;
    private FlowLayout fl = new FlowLayout();
    Oiseau oiseau;

    public Fenetre(GestionDonnees gd2) {
        this.gd = gd2;
        int espH = this.fl.getHgap();
        int espV = this.fl.getVgap();
        int largeurGauche = 480;
        int largeurDroite = 320;
        int largeurBas = 800;
        int hauteurGauche = 600;
        int hauteurDroite = 600;
        int hauteurBas = 50;
        int largeurCentre = espH + largeurGauche + espH + largeurDroite + espH;
        int hauteurCentre = espV + hauteurGauche + espV;
        int largeurFenetre = largeurCentre;
        int hauteurFenetre = hauteurCentre + hauteurBas;
        this.bonneReponseBoutons = 0;
        this.bonneReponseOiseau = this.gd.getIndexAleatoire(0);
        this.oiseau = this.gd.getOiseau(this.bonneReponseOiseau);
        this.lecteur = new JLecteurMP3(this.oiseau);
        this.lecteur.setTitre(this.gd.getTxt("question", 0));
        this.lecteur.setCache(false);
        this.boutons = new JButton[this.nbBoutons];
        int i = 0;
        while (i < this.nbBoutons) {
            this.boutons[i] = new JButton(this.gd.getNomAleatoire(i));
            this.boutons[i].addActionListener(this);
            this.boutons[i].setFocusable(false);
            ++i;
        }
        this.initBoutons();
        this.gauche = new JPanel(new GridBagLayout());
        this.gauche.setPreferredSize(new Dimension(largeurGauche, hauteurGauche));
        this.gauche.add(this.lecteur);
        this.droite = new Box(1);
        this.droite.setPreferredSize(new Dimension(largeurDroite, hauteurDroite));
        i = 0;
        while (i < this.nbBoutons) {
            this.droite.add(Box.createRigidArea(new Dimension(10, 10)));
            this.droite.add(this.boutons[i]);
            ++i;
        }
        this.droite.setVisible(false);
        this.centre = new JPanel(this.fl);
        this.centre.setPreferredSize(new Dimension(largeurCentre, hauteurCentre));
        this.centre.add(this.gauche);
        this.centre.add(this.droite);
        this.bas = new JPanel(this.fl);
        this.bas.setPreferredSize(new Dimension(largeurBas, hauteurBas));
        this.bas.add(this.btnPlay);
        this.bas.add(this.btnStop);
        this.bas.add(this.btnLangue);
        this.bas.add(this.btnGalerie);
        this.bas.add(this.btnSonotheque);
        this.bas.add(this.btnAide);
        this.bas.add(this.btnAPropos);
        this.fenetre = new Box(1);
        this.fenetre.setPreferredSize(new Dimension(largeurFenetre, hauteurFenetre));
        this.fenetre.add(this.centre);
        this.fenetre.add(this.bas);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add(this.fenetre);
        this.setTitle(this.gd.getTxt("titreFenetre", 0));
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.lecteur.joue();
    }

    private void initBoutons() {
        this.btnPlay = this.initBtn("btnPlay", true);
        this.btnStop = this.initBtn("btnStop", false);
        this.btnLangue = this.initBtn("btnLangue", true);
        this.btnSonotheque = this.initBtn("btnSonotheque", true);
        this.btnGalerie = this.initBtn("btnGalerie", true);
        this.btnAide = this.initBtn("btnAide", true);
        this.btnAPropos = this.initBtn("btnAPropos", true);
    }

    private JButton initBtn(String id, boolean enabled) {
        JButton btn = new JButton();
        this.modifBtn(btn, id);
        btn.addActionListener(this);
        btn.setFocusable(false);
        btn.setEnabled(enabled);
        return btn;
    }

    private void modifBtn(JButton btn, String id) {
        btn.setText(this.gd.getTxt(id, 0));
        btn.setToolTipText(this.gd.getTxt(id, 1));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.btnStop) {
            this.arreter();
            return;
        }
        if (arg0.getSource() == this.btnPlay) {
            this.lancer();
            return;
        }
        if (arg0.getSource() == this.btnLangue) {
            this.choisirLangue();
            return;
        }
        if (arg0.getSource() == this.btnGalerie) {
            this.galerie();
            return;
        }
        if (arg0.getSource() == this.btnSonotheque) {
            this.sonotheque();
            return;
        }
        if (arg0.getSource() == this.btnAide) {
            this.aide();
            return;
        }
        if (arg0.getSource() == this.btnAPropos) {
            this.aPropos();
            return;
        }
        if (arg0.getSource() == this.boutons[this.bonneReponseBoutons]) {
            this.bonneReponse();
        } else {
            this.mauvaiseReponse();
        }
    }

    private void aPropos() {
        String texte = this.gd.getLicences();
        new JDialogTexteInformatif(this, "Informations sur les donn\u00e9es du programme", texte);
    }

    private void lancer() {
        this.btnPlay.setEnabled(false);
        this.btnStop.setEnabled(true);
        this.btnGalerie.setEnabled(false);
        this.btnSonotheque.setEnabled(false);
        this.lecteur.stop();
        this.gauche.setVisible(true);
        this.droite.setVisible(true);
        this.choixSon();
    }

    private void arreter() {
        this.lecteur.stop();
        String message = this.gd.getTxt("arret", 0);
        if (this.nbQuestions > 0) {
            int pourcentage = (int)(100.0 * ((double)this.nbBonnesReponses / (double)this.nbQuestions));
            message = String.valueOf(message) + "\n" + pourcentage + "% " + this.gd.getTxt("arret", 1);
        }
        this.nbQuestions = 0;
        this.nbBonnesReponses = 0;
        int i = 0;
        while (i < this.nbBoutons) {
            this.boutons[i].setVisible(false);
            ++i;
        }
        JOptionPane.showMessageDialog(this, message);
        this.btnPlay.setEnabled(true);
        this.btnStop.setEnabled(false);
        this.btnGalerie.setEnabled(true);
        this.btnSonotheque.setEnabled(true);
        this.lecteur.setCache(false);
    }

    private void choisirLangue() {
        boolean lectureEnCours;
        boolean bl = lectureEnCours = !this.lecteur.isPaused();
        if (lectureEnCours) {
            this.lecteur.pauseChant();
        }
        new JDialogChoixLangue(this, this.gd);
        this.modifBoutons();
        this.setTitle(this.gd.getTxt("titreFenetre", 0));
        int i = 0;
        while (i < this.nbBoutons) {
            this.boutons[i].setText(this.gd.getNomAleatoire(i));
            ++i;
        }
        String nom = this.gd.getNomAleatoire(this.bonneReponseBoutons);
        this.lecteur.setNom(nom);
        this.lecteur.setTitre(this.gd.getTxt("question", 0));
        this.oiseau.changeNom(nom);
        this.lecteur.changeBordure();
        if (lectureEnCours) {
            this.lecteur.resumeChant();
        }
    }

    private void galerie() {
        this.lecteur.stop();
        new JDialogGalerie(this, this.gd);
    }

    private void sonotheque() {
        this.lecteur.stop();
        new JDialogSonotheque(this, this.gd);
    }

    private void aide() {
        String texte = this.gd.getAide();
        new JDialogTexteInformatif(this, "Aide", texte);
    }

    private void mauvaiseReponse() {
        this.lecteur.setCache(false);
        String s = "<html><div width = 300px align = justify>" + this.gd.getTxt("mauvaiseReponse", 0) + "<br>" + this.gd.getTxt("mauvaiseReponse", 1) + " " + this.oiseau.getInfo() + "</div></html>";
        JOptionPane.showMessageDialog(this, s);
        this.lecteur.stop();
        ++this.nbQuestions;
        this.choixSon();
    }

    private void bonneReponse() {
        this.lecteur.setCache(false);
        String s = "<html><div width = 300px align = justify>" + this.gd.getTxt("bonneReponse", 0) + "<br>" + this.oiseau.getInfo() + "</div></html>";
        JOptionPane.showMessageDialog(this, s);
        this.lecteur.stop();
        ++this.nbBonnesReponses;
        ++this.nbQuestions;
        this.choixSon();
    }

    private void choixSon() {
        this.gd.ajouterNumeroExclu(this.bonneReponseOiseau);
        List<Integer> liste = this.gd.tirer(10);
        this.bonneReponseBoutons = (int)((double)this.nbBoutons * Math.random());
        int i = 0;
        while (i < this.nbBoutons) {
            this.boutons[i].setText(this.gd.getNom(liste.get(i)));
            this.boutons[i].setVisible(true);
            ++i;
        }
        this.bonneReponseOiseau = liste.get(this.bonneReponseBoutons);
        this.oiseau = this.gd.getOiseau(this.bonneReponseOiseau);
        this.lecteur.setCache(true);
        this.lecteur.change(this.oiseau);
        double x = 1.0 - 0.75 * Math.random();
        this.lecteur.joue(x);
    }

    private void modifBoutons() {
        this.modifBtn(this.btnPlay, "btnPlay");
        this.modifBtn(this.btnStop, "btnStop");
        this.modifBtn(this.btnLangue, "btnLangue");
        this.modifBtn(this.btnSonotheque, "btnSonotheque");
        this.modifBtn(this.btnGalerie, "btnGalerie");
        this.modifBtn(this.btnAide, "btnAide");
        this.modifBtn(this.btnAPropos, "btnAPropos");
    }
}

