/*
 * Decompiled with CFR 0.152.
 */
package memory.outils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class ModifiedFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = 6707455474250629161L;

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.computeSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeSize(Container cible) {
        Object object = cible.getTreeLock();
        synchronized (object) {
            Insets insets;
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int w = cible.getWidth();
            if (w == 0) {
                w = Integer.MAX_VALUE;
            }
            if ((insets = cible.getInsets()) == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            int largeur = 0;
            int maxLargeur = w - (insets.left + insets.right + hgap * 2);
            int n = cible.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int hauteur = 0;
            int i = 0;
            while (i < n) {
                Component c = cible.getComponent(i);
                if (c.isVisible()) {
                    Dimension d = c.getPreferredSize();
                    if (x == 0 || x + d.width <= maxLargeur) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        hauteur = Math.max(hauteur, d.height);
                    } else {
                        x = d.width;
                        y += vgap + hauteur;
                        hauteur = d.height;
                    }
                    largeur = Math.max(largeur, x);
                }
                ++i;
            }
            y += hauteur;
            return new Dimension(largeur + insets.left + insets.right, y += insets.bottom);
        }
    }
}

