/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import memory.chants.GestionDonnees;
import memory.chants.Oiseau;
import memory.lecteur.LecteurEvent;
import memory.lecteur.LecteurException;
import memory.lecteur.LecteurListener;
import memory.lecteur.LecteurMP3;
import memory.outils.BordureDouble;
import memory.outils.Observable;
import memory.outils.Observateur;

public class JLecteurMP3
extends JPanel
implements ActionListener,
ChangeListener,
LecteurListener,
Observable {
    private static final long serialVersionUID = 1L;
    public static Color COULEUR_INFO_BULLE = new Color(255, 255, 204);
    private LecteurMP3 lecteur;
    private String mp3;
    private String nom;
    private String titre;
    private String nomLatin;
    private String infos;
    private JProgressBar progression = new JProgressBar(0, 100);
    private JButton btnPlay;
    private JButton btnPause;
    private JButton btnArret;
    private boolean paused = false;
    private boolean stopped = true;
    private boolean boucle = true;
    private boolean cache = false;
    private int etatBoutons;
    private JSlider volume;
    private JPanel boutons;
    private JLabel lblImage;
    private ImageIcon image;
    private ImageIcon iconPlay = new ImageIcon("." + File.separator + "icones" + File.separator + "play.png");
    private ImageIcon iconPause = new ImageIcon("." + File.separator + "icones" + File.separator + "pause.png");
    private ImageIcon iconStop = new ImageIcon("." + File.separator + "icones" + File.separator + "arret.png");
    private static ImageIcon defaut;
    private JPanel panImage;
    private BordureDouble bordure;
    private List<Observateur> observateurs = new ArrayList<Observateur>();

    public JLecteurMP3(Oiseau oiseau) {
        this.lecteur = new LecteurMP3();
        this.lecteur.addLecteurListener(this);
        this.mp3 = oiseau.getChant();
        this.image = oiseau.getImage();
        this.nom = oiseau.getNom();
        this.nomLatin = oiseau.getNomLatin();
        this.infos = oiseau.getInfo();
        JLecteurMP3.initImageDefaut();
        this.panImage = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public JToolTip createToolTip() {
                JToolTip tip = super.createToolTip();
                tip.setBackground(COULEUR_INFO_BULLE);
                tip.setForeground(Color.DARK_GRAY);
                tip.setPreferredSize(new Dimension(500, 300));
                return tip;
            }

            @Override
            public Point getToolTipLocation(MouseEvent e) {
                return new Point(this.getWidth(), this.getHeight());
            }
        };
        this.bordure = new BordureDouble(this.cache ? this.titre : this.nom, this.cache ? this.titre : this.nomLatin);
        this.panImage.setBorder(this.bordure);
        this.panImage.setLayout(new FlowLayout());
        this.lblImage = new JLabel(this.cache ? defaut : this.image);
        this.panImage.add(this.lblImage);
        this.volume = new JSlider(1, 0, 100, 85);
        this.volume.setMajorTickSpacing(20);
        this.volume.setMinorTickSpacing(5);
        this.volume.setPaintTicks(true);
        this.volume.setPaintLabels(true);
        this.volume.addChangeListener(this);
        this.btnPlay = new JButton();
        this.btnPlay.setIcon(this.iconPlay);
        this.btnPlay.addActionListener(this);
        this.btnPlay.setEnabled(true);
        this.btnPause = new JButton();
        this.btnPause.setIcon(this.iconPause);
        this.btnPause.addActionListener(this);
        this.btnPause.setEnabled(false);
        this.btnArret = new JButton();
        this.btnArret.setIcon(this.iconStop);
        this.btnArret.addActionListener(this);
        this.btnArret.setEnabled(false);
        this.etatBoutons = 1;
        this.boutons = new JPanel();
        this.boutons.add(this.btnPlay);
        this.boutons.add(this.btnPause);
        this.boutons.add(this.btnArret);
        this.boutons.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.progression, "North");
        this.setForeground(Color.CYAN);
        this.add((Component)this.volume, "East");
        this.add((Component)this.boutons, "South");
        this.add((Component)this.panImage, "Center");
    }

    private static void initImageDefaut() {
        if (defaut == null) {
            ImageIcon image = new ImageIcon("." + File.separator + "icones" + File.separator + "defaut1.jpg");
            int largeur = image.getIconWidth();
            int hauteur = image.getIconHeight();
            int largeurImage = 250;
            if (largeur > hauteur) {
                hauteur = hauteur * largeurImage / largeur;
                largeur = largeurImage;
            } else {
                largeur = largeur * largeurImage / hauteur;
                hauteur = largeurImage;
            }
            defaut = new ImageIcon(image.getImage().getScaledInstance(largeur, hauteur, 1));
        }
    }

    public void changeBordure() {
        if (this.cache) {
            this.bordure.setTitreHaut(this.titre);
            this.bordure.setTitreBas("");
        } else {
            this.bordure.setTitreHaut(this.nom);
            this.bordure.setTitreBas(this.nomLatin);
        }
        this.panImage.repaint();
    }

    private void joueChant() {
        try {
            this.lecteur.open(new File(this.mp3));
            this.lecteur.play();
        }
        catch (LecteurException e) {
            e.printStackTrace();
        }
    }

    private void joueChant(double x) {
        try {
            this.lecteur.open(new File(this.mp3));
            this.lecteur.skip(x);
            this.lecteur.play();
        }
        catch (LecteurException e) {
            e.printStackTrace();
        }
    }

    public void stopChant() {
        this.progression.setValue(0);
        this.lecteur.stop();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.btnPlay) {
            this.joue();
            return;
        }
        if (evt.getSource() == this.btnPause) {
            this.stopped = false;
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                this.btnPause.setIcon(this.iconPlay);
                if (this.etatBoutons != 2) {
                    this.gererBoutons(false, true, false);
                }
                this.pauseChant();
            } else {
                this.btnPause.setIcon(this.iconPause);
                if (this.etatBoutons != 6) {
                    this.gererBoutons(false, true, true);
                }
                this.resumeChant();
            }
            return;
        }
        if (evt.getSource() == this.btnArret) {
            this.stop();
            return;
        }
    }

    public void joue() {
        this.stopped = false;
        this.paused = false;
        this.btnPause.setIcon(this.iconPause);
        if (this.etatBoutons != 6) {
            this.gererBoutons(false, true, true);
        }
        this.joueChant();
    }

    public void joue(double x) {
        this.stopped = false;
        this.paused = false;
        this.btnPause.setIcon(this.iconPause);
        if (this.etatBoutons != 6) {
            this.gererBoutons(false, true, true);
        }
        this.joueChant(x);
    }

    public void stop() {
        this.stopped = true;
        this.paused = false;
        this.btnPause.setIcon(this.iconPause);
        if (this.etatBoutons != 1) {
            this.gererBoutons(true, false, false);
        }
        this.stopChant();
    }

    public void resumeChant() {
        this.lecteur.resume();
    }

    public void pauseChant() {
        this.lecteur.pause();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.volume) {
            double valeur = (double)this.volume.getValue() / 100.0;
            try {
                this.lecteur.setGain(valeur);
            }
            catch (LecteurException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        GestionDonnees gd = new GestionDonnees();
        Oiseau oiseau = new Oiseau(gd.getNom(0), gd.getNomLatin(0), gd.getFichierSon(0), gd.getFichierImage(0), gd.getInfo(0));
        final JLecteurMP3 lecteurMP3 = new JLecteurMP3(oiseau);
        lecteurMP3.setCache(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame fenetre = new JFrame();
                fenetre.add(lecteurMP3);
                fenetre.pack();
                fenetre.setVisible(true);
                fenetre.setDefaultCloseOperation(3);
            }
        });
        lecteurMP3.setBoucle(true);
        lecteurMP3.joue(0.9);
    }

    @Override
    public void stateUpdated(LecteurEvent event) {
        if (event.getCode() == 3 && !this.stopped) {
            if (this.boucle) {
                try {
                    this.lecteur.play();
                }
                catch (LecteurException e) {
                    e.printStackTrace();
                }
            } else {
                this.updateObservateurs();
            }
        }
    }

    private void gererBoutons(final boolean etatRun, final boolean etatPause, final boolean etatStop) {
        this.etatBoutons = (etatStop ? 4 : 0) + (etatPause ? 2 : 0) + (etatRun ? 1 : 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLecteurMP3.this.btnPlay.setEnabled(etatRun);
                JLecteurMP3.this.btnPause.setEnabled(etatPause);
                JLecteurMP3.this.btnArret.setEnabled(etatStop);
                JLecteurMP3.this.revalidate();
            }
        });
    }

    public void setCache(boolean b) {
        this.cache = b;
        if (b) {
            this.lblImage.setIcon(defaut);
            this.bordure.setTitreHaut(this.titre);
            this.bordure.setTitreBas("");
            this.panImage.setToolTipText("");
        } else {
            this.lblImage.setIcon(this.image);
            this.bordure.setTitreHaut(this.nom);
            this.bordure.setTitreBas(this.nomLatin);
            this.panImage.setToolTipText("<html>" + this.infos + "</html>");
        }
    }

    public void change(Oiseau oiseau) {
        this.image = oiseau.getImage();
        this.mp3 = oiseau.getChant();
        this.nom = oiseau.getNom();
        this.nomLatin = oiseau.getNomLatin();
        this.infos = oiseau.getInfo();
    }

    public void setNom(String nom2) {
        this.nom = nom2;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    @Override
    public void addObservateur(Observateur obs) {
        this.observateurs.add(obs);
    }

    @Override
    public void updateObservateurs() {
        for (Observateur obs : this.observateurs) {
            obs.update();
        }
    }

    @Override
    public void delObservateurs() {
        this.observateurs = new ArrayList<Observateur>();
    }

    public void setBoucle(boolean boucle) {
        this.boucle = boucle;
    }

    @Override
    public void progress(Long microseconds) {
        final int progres = (int)(microseconds / 1000000L);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLecteurMP3.this.progression.setValue(progres);
            }
        });
    }

    @Override
    public void opened(Long microsecondes) {
        final int duree = (int)(microsecondes / 1000000L);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLecteurMP3.this.progression.setMaximum(duree);
            }
        });
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public BordureDouble getBordure() {
        return this.bordure;
    }

    public void setBordure(BordureDouble bordure) {
        this.bordure = bordure;
    }
}

