/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.awt.Desktop;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import memory.chants.Fenetre;
import memory.chants.GestionDonnees;

public class JDialogTexteInformatif
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = -7863608399219352796L;

    public JDialogTexteInformatif(Fenetre fenetre, GestionDonnees gd, String titre) {
        super(fenetre, gd.getTxt("titreAide", 0), true);
        this.setSize(new Dimension(800, 500));
        this.setLocationRelativeTo(null);
        JEditorPane jep = new JEditorPane();
        jep.setEditable(false);
        jep.setContentType("text/html");
        jep.setText(titre.equals("titreAide") ? gd.getAide() : gd.getLicences());
        jep.setCaretPosition(0);
        jep.addHyperlinkListener(this);
        this.add(new JScrollPane(jep));
        this.setVisible(true);
    }

    public JDialogTexteInformatif(Fenetre fenetre, String titre, String texte) {
        super(fenetre, titre, true);
        this.setSize(new Dimension(800, 500));
        this.setLocationRelativeTo(null);
        JEditorPane jep = new JEditorPane();
        jep.setEditable(false);
        jep.setContentType("text/html");
        jep.setText(texte);
        jep.setCaretPosition(0);
        jep.addHyperlinkListener(this);
        this.add(new JScrollPane(jep));
        this.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URI uri = ev.getURL().toURI();
                if (Desktop.isDesktopSupported()) {
                    if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(uri);
                    } else {
                        JOptionPane.showMessageDialog(this, "Je ne parviens pas \u00e0 ouvrir votre navigateur Internet.");
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Je ne parviens pas \u00e0 ouvrir votre navigateur Internet.");
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        GestionDonnees gd = new GestionDonnees();
        final String texte = gd.getLicences();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JDialogTexteInformatif(null, "sources", texte);
            }
        });
    }
}

