/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import memory.chants.Fenetre;
import memory.chants.GestionDonnees;
import memory.chants.JLecteurMP3;
import memory.chants.Oiseau;
import memory.outils.Observateur;

public class JDialogSonotheque
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8571587227515623822L;
    private GestionDonnees gd;
    private JLecteurMP3 lecteur;
    private JButton avance;
    private JButton recule;
    private JProgressBar progression;
    private int numeroImage = 0;
    private boolean enAvant = true;

    public JDialogSonotheque(Fenetre fenetre, GestionDonnees gd2) {
        super(fenetre, gd2.getTxt("titreSonotheque", 0), true);
        this.gd = gd2;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JDialogSonotheque.this.getLecteur().stop();
                JDialogSonotheque.this.dispose();
            }
        });
        JPanel panneauCentral = new JPanel();
        JPanel panneauBas = new JPanel();
        JPanel panneauProgression = new JPanel();
        JPanel panneauBoutons = new JPanel();
        this.progression = new JProgressBar(0, this.gd.getNbDonnees() - 1);
        this.progression.setPreferredSize(new Dimension(500, 20));
        this.progression.setStringPainted(true);
        this.avance = new JButton();
        this.avance.setIcon(new ImageIcon("." + File.separator + "icones" + File.separator + "suivant.png"));
        this.avance.setFocusPainted(false);
        this.avance.addActionListener(this);
        this.recule = new JButton();
        this.recule.setIcon(new ImageIcon("." + File.separator + "icones" + File.separator + "precedent.png"));
        this.recule.setFocusPainted(false);
        this.recule.addActionListener(this);
        panneauProgression.add(this.progression);
        panneauBoutons.add(this.recule);
        panneauBoutons.add(this.avance);
        panneauBas.setLayout(new BoxLayout(panneauBas, 1));
        panneauBas.add(panneauProgression);
        panneauBas.add(panneauBoutons);
        Oiseau oiseau = this.gd.getOiseau(0);
        this.lecteur = new JLecteurMP3(oiseau);
        this.lecteur.setBoucle(false);
        this.lecteur.addObservateur(new Observateur(){

            @Override
            public void update() {
                if (JDialogSonotheque.this.enAvant) {
                    JDialogSonotheque.this.avancer();
                } else {
                    JDialogSonotheque.this.reculer();
                }
            }
        });
        this.lecteur.joue();
        panneauCentral.add(this.lecteur);
        this.getContentPane().add((Component)panneauBas, "South");
        this.getContentPane().add((Component)panneauCentral, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void afficher() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogSonotheque.this.progression.setValue(JDialogSonotheque.this.numeroImage);
                JDialogSonotheque.this.repaint();
                JDialogSonotheque.this.pack();
            }
        });
        this.lecteur.joue();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.avance) {
            this.getLecteur().stop();
            this.avancer();
        }
        if (evt.getSource() == this.recule) {
            this.getLecteur().stop();
            this.reculer();
        }
    }

    private void reculer() {
        this.enAvant = false;
        if (this.numeroImage == 0) {
            this.numeroImage = this.gd.getNbDonnees();
        }
        --this.numeroImage;
        Oiseau oiseau = this.gd.getOiseau(this.numeroImage);
        this.getLecteur().change(oiseau);
        this.getLecteur().setCache(false);
        this.afficher();
    }

    private void avancer() {
        this.enAvant = true;
        ++this.numeroImage;
        if (this.numeroImage == this.gd.getNbDonnees()) {
            this.numeroImage = 0;
        }
        Oiseau oiseau = this.gd.getOiseau(this.numeroImage);
        this.getLecteur().change(oiseau);
        this.getLecteur().setCache(false);
        this.afficher();
    }

    public JLecteurMP3 getLecteur() {
        return this.lecteur;
    }
}

