/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import memory.chants.Oiseau;
import memory.outils.Fichier;
import memory.outils.ListeAMelanger;
import memory.outils.Messages;

public class GestionDonnees {
    private static String LANGUE_DEFAUT = "Fran\u00e7ais";
    public static String CHEMIN = "." + File.separator + "donnees" + File.separator;
    private static String DONNEES = String.valueOf(CHEMIN) + "donnees.txt";
    private static String LANGUES = String.valueOf(CHEMIN) + "langues.txt";
    private static String LICENCES = String.valueOf(CHEMIN) + "licences.txt";
    private String[] donnees;
    private int nbDonnees;
    private ListeAMelanger lam;
    private String langue = "";
    private Map<String, String> noms;
    private Map<String, String> nomsLatins = new HashMap<String, String>();
    private Map<String, String> messages;
    private String[] langues;
    private String aide = "";
    private String licences = "";
    private String fichier_licences = "";
    private String fichier_aide = "";
    String[] infos;

    public GestionDonnees() {
        String contenu;
        try {
            contenu = Fichier.chargerContenuTexte(DONNEES);
            this.donnees = contenu.split("\n");
            contenu = Fichier.chargerContenuTexte(String.valueOf(CHEMIN) + "latin.txt");
            String[] lignes = contenu.split("\n");
            this.nomsLatins = new HashMap<String, String>();
            int i = 0;
            while (i < lignes.length) {
                String[] ligne = lignes[i].split(";");
                String identifiant = ligne[0];
                String nom = ligne[1];
                this.nomsLatins.put(identifiant, nom);
                ++i;
            }
            this.nbDonnees = this.donnees.length;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            contenu = Fichier.chargerContenuTexte(LANGUES);
            this.langues = contenu.split("\n");
            this.setLangue(LANGUE_DEFAUT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lam = new ListeAMelanger(this.nbDonnees);
        this.lam.melanger();
    }

    public String getDonnees(int n) {
        return this.donnees[n];
    }

    public String getNom(int n) {
        String identifiant = this.donnees[n].split(";")[0];
        return this.noms.get(identifiant);
    }

    public String getNomAleatoire(int n) {
        return this.getNom(this.lam.getElement(n));
    }

    public String getFichierSon(int n) {
        String s = this.donnees[n];
        String[] resultat = s.split(";");
        return "." + File.separator + "chants" + File.separator + resultat[1];
    }

    public String getFichierSonAleatoire(int n) {
        return this.getFichierSon(this.lam.getElement(n));
    }

    public String getFichierImage(int n) {
        String s = this.donnees[n];
        String[] resultat = s.split(";");
        return "." + File.separator + "images" + File.separator + resultat[2];
    }

    public String getFichierImageAleatoire(int n) {
        return this.getFichierImage(this.lam.getElement(n));
    }

    public String getNomLatin(int n) {
        String identifiant = this.donnees[n].split(";")[0];
        return this.nomsLatins.get(identifiant);
    }

    public String getNomLatinAleatoire(int n) {
        return this.getNomLatin(this.lam.getElement(n));
    }

    public int getIndexAleatoire(int n) {
        return this.lam.getElement(n);
    }

    public int getNbLangues() {
        return this.langues.length;
    }

    public String getLangue(int n) {
        return this.langues[n].split(";")[0];
    }

    public int getNbDonnees() {
        return this.nbDonnees;
    }

    public String getIdentifiant(int n) {
        return this.donnees[n].split(";")[0];
    }

    public String getTxt(String identifiant, int n) {
        String S = this.messages.get(identifiant);
        return S.split("&")[n];
    }

    public String getAide() {
        if (this.aide.isEmpty() || !this.aide.startsWith("<html>")) {
            try {
                this.aide = Fichier.chargerContenuTexte(this.fichier_aide);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.aide;
    }

    public void setLangue(String langue) {
        if (!langue.equals(this.langue)) {
            this.langue = langue;
            String[] stringArray = this.langues;
            int n = this.langues.length;
            int n2 = 0;
            while (n2 < n) {
                String langueFichier = stringArray[n2];
                String[] s = langueFichier.split(";");
                if (langue.equals(s[0])) {
                    this.chargerDonnees(String.valueOf(CHEMIN) + s[1]);
                    this.fichier_aide = String.valueOf(CHEMIN) + s[2];
                    this.aide = "";
                    this.chargerMessages(String.valueOf(CHEMIN) + s[3]);
                    this.fichier_licences = String.valueOf(CHEMIN) + s[4];
                    this.licences = "";
                    break;
                }
                ++n2;
            }
        }
        if (langue.equals(LANGUE_DEFAUT)) {
            this.chargerInfos(String.valueOf(CHEMIN) + "oiseaux.fr.txt");
        } else {
            this.infos = new String[0];
        }
    }

    private void chargerInfos(String fichier) {
        try {
            String contenu = Fichier.chargerContenuTexte(fichier);
            this.infos = contenu.split("<info>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void melanger() {
        this.lam.melanger();
    }

    public List<Integer> tirer(int n) {
        return this.lam.tirer(n);
    }

    public void ajouterNumeroExclu(int n) {
        this.lam.ajouterNumeroAExclure(n);
    }

    private void chargerMessages(String fichier) {
        try {
            String contenu = Fichier.chargerContenuTexte(fichier);
            String[] lignes = contenu.split("\n");
            this.messages = new HashMap<String, String>();
            int i = 0;
            while (i < lignes.length) {
                String[] ligne = lignes[i].split(";");
                String idMessage = ligne[0];
                String textesMessage = ligne[1];
                this.messages.put(idMessage, textesMessage);
                ++i;
            }
        }
        catch (IOException e) {
            Messages.messageInfo("erreur en lecture de " + fichier);
            e.printStackTrace();
        }
    }

    private void chargerDonnees(String fichier) {
        try {
            String contenu = Fichier.chargerContenuTexte(fichier);
            String[] lignes = contenu.split("\n");
            this.noms = new HashMap<String, String>();
            int i = 0;
            while (i < lignes.length) {
                String[] ligne = lignes[i].split(";");
                String identifiant = ligne[0];
                String nom = ligne[1];
                this.noms.put(identifiant, nom);
                ++i;
            }
        }
        catch (IOException e) {
            Messages.messageInfo("erreur en lecture de " + fichier);
            e.printStackTrace();
        }
    }

    public String getLicences() {
        if (this.licences.isEmpty() || !this.licences.startsWith("<html>")) {
            try {
                this.licences = Fichier.chargerContenuTexte(this.fichier_licences);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.licences;
    }

    public Oiseau getOiseau(int i) {
        String nom = this.getNom(i);
        String nomLatin = this.getNomLatin(i);
        String fichierSon = this.getFichierSon(i);
        String fichierImage = this.getFichierImage(i);
        String info = this.getInfo(nomLatin);
        return new Oiseau(nom, nomLatin, fichierSon, fichierImage, info);
    }

    public String getInfo(String nom) {
        if (this.infos.length == 0) {
            return null;
        }
        String identifiant = "";
        String[] stringArray = this.infos;
        int n = this.infos.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            identifiant = s.split("\n")[0];
            if (identifiant.equals(nom)) {
                return s.replace("\n", " ").replace(identifiant, "");
            }
            ++n2;
        }
        return null;
    }

    public String getInfo(int i) {
        return this.getInfo(this.getNomLatin(i));
    }
}

