/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.math;

import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.utiles.exttypes.Flottants;
import fr.histoiremondiale.histoire.utiles.math.CalculsEspace;
import fr.histoiremondiale.histoire.utiles.math.Matrice;
import fr.histoiremondiale.histoire.utiles.math.PointEspace;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;

public class CoordSphere {
    public static final int ANGLE = 30;
    public static final double cosAngle = Math.cos(Math.toRadians(30.0));
    public static final double sinAngle = Math.sin(Math.toRadians(30.0));

    public static Matrice matChgtSphereVersPlan(PointSphere pointSphere) {
        double d = Math.cos(Math.toRadians(pointSphere.longitude()));
        double d2 = Math.sin(Math.toRadians(pointSphere.longitude()));
        double d3 = Math.cos(Math.toRadians(pointSphere.latitude()));
        double d4 = Math.sin(Math.toRadians(pointSphere.latitude()));
        double[][] dArrayArray = new double[][]{{d * d3, -d2, -d * d4}, {d2 * d3, d, -d2 * d4}, {d4, 0.0, d3}};
        return new Matrice(dArrayArray);
    }

    public static Matrice matChgtSphereVersPlan2(PointSphere pointSphere) {
        double d = Math.cos(Math.toRadians(pointSphere.longitude()));
        double d2 = Math.sin(Math.toRadians(pointSphere.longitude()));
        double d3 = Math.cos(Math.toRadians(pointSphere.latitude()));
        double d4 = Math.sin(Math.toRadians(pointSphere.latitude()));
        double[][] dArrayArray = new double[][]{{d * d3, d2 * d3, d4}, {-d2, d, 0.0}, {-d * d4, -d2 * d4, d3}};
        return new Matrice(dArrayArray);
    }

    public static Matrice matChgtPlanVersSphere(PointSphere pointSphere) {
        return CoordSphere.matChgtSphereVersPlan(pointSphere).transformation();
    }

    public static PointPlan coordSphereVersPlan(PointSphere pointSphere, Matrice matrice, double d, double d2, double d3) {
        double d4;
        double d5 = d > d2 ? d : d2;
        double d6 = Math.toRadians(pointSphere.longitude());
        double d7 = Math.toRadians(pointSphere.latitude());
        double d8 = Math.cos(Math.toRadians(30.0));
        double d9 = Math.sin(Math.toRadians(30.0));
        double d10 = d4 = d5 * d8 / (2.0 * d9);
        double[] dArray = new double[]{Math.cos(d7) * Math.cos(d6), Math.cos(d7) * Math.sin(d6), Math.sin(d7)};
        double[] dArray2 = new double[]{matrice.val(1, 1) * dArray[0] + matrice.val(2, 1) * dArray[1] + matrice.val(3, 1) * dArray[2], matrice.val(1, 2) * dArray[0] + matrice.val(2, 2) * dArray[1] + matrice.val(3, 2) * dArray[2], matrice.val(1, 3) * dArray[0] + matrice.val(2, 3) * dArray[1] + matrice.val(3, 3) * dArray[2]};
        if (dArray2[0] < 1.0E-5) {
            dArray2[0] = 1.0E-5;
        }
        double d11 = d4 * d3 * dArray2[1] / dArray2[0];
        double d12 = -d10 * d3 * dArray2[2] / dArray2[0];
        return new PointPlan(d11, d12);
    }

    public static PointSphere coordPlanVersSphere(PointPlan pointPlan, PointSphere pointSphere, Matrice matrice, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7 = d > d2 ? d : d2;
        double d8 = Math.cos(Math.toRadians(30.0));
        double d9 = Math.sin(Math.toRadians(30.0));
        double d10 = d6 = d7 * d8 / (2.0 * d9);
        double d11 = (pointPlan.x() - d / 2.0) / (d3 * d6);
        double d12 = (d2 / 2.0 - pointPlan.y()) / (d3 * d10);
        double d13 = 1.0 / Math.sqrt(1.0 + d11 * d11 + d12 * d12);
        double d14 = d11 * d13;
        double d15 = d12 * d13;
        double[] dArray = new double[]{matrice.val(1, 1) * d13 + matrice.val(2, 1) * d14 + matrice.val(3, 1) * d15, matrice.val(1, 2) * d13 + matrice.val(2, 2) * d14 + matrice.val(3, 2) * d15, matrice.val(1, 3) * d13 + matrice.val(2, 3) * d14 + matrice.val(3, 3) * d15};
        if (Flottants.arrondir(Math.abs(dArray[2]), 5) == 1.0) {
            d5 = pointSphere.longitude();
            d4 = dArray[2] > 0.0 ? 90 : -90;
        } else if (Flottants.arrondir(dArray[0], 5) == 0.0) {
            d5 = dArray[1] > 0.0 ? 90 : -90;
            d4 = Flottants.arrondir(Math.toDegrees(Math.atan(dArray[2] / Math.abs(dArray[1]))), 2);
        } else {
            d5 = Flottants.arrondir(Math.toDegrees(Math.atan(dArray[1] / dArray[0])), 2);
            if ((d5 += (double)(dArray[0] > 0.0 ? 0 : 180)) > 180.0) {
                d5 -= 360.0;
            }
            d4 = Flottants.arrondir(Math.toDegrees(Math.atan(Math.cos(Math.toRadians(d5)) * dArray[2] / dArray[0])), 2);
        }
        return new PointSphere(d5, d4);
    }

    public static PointPlan projection(PointSphere pointSphere, Matrice matrice, double d, int n) {
        PointEspace pointEspace = CalculsEspace.ptEspaceDepuisPtSphere(pointSphere);
        PointEspace pointEspace2 = CalculsEspace.multiplier(matrice, pointEspace);
        PointPlan pointPlan = CalculsEspace.projection(pointEspace2, d, n);
        return pointPlan;
    }

    public static PointSphere InvProjection(PointPlan pointPlan, PointSphere pointSphere, int n, int n2, double d) {
        double d2 = Math.max(n2, n);
        double d3 = pointPlan.x() + (d2 - (double)n) / 2.0;
        double d4 = pointPlan.y() + (d2 - (double)n2) / 2.0;
        double d5 = d2 / PanCarte.COEFFT_CARTE;
        double d6 = (d3 - d2 / 2.0) / (d * d5);
        double d7 = (d2 / 2.0 - d4) / (d * d5);
        double d8 = 1.0 / Math.sqrt(1.0 + d6 * d6 + d7 * d7);
        double d9 = d6 * d8;
        double d10 = d7 * d8;
        double d11 = pointSphere.getCosLo() * pointSphere.getCosLa() * d8 - pointSphere.getSinLo() * d9 - pointSphere.getCosLo() * pointSphere.getSinla() * d10;
        double d12 = pointSphere.getSinLo() * pointSphere.getCosLa() * d8 + pointSphere.getCosLo() * d9 - pointSphere.getSinLo() * pointSphere.getSinla() * d10;
        double d13 = pointSphere.getSinla() * d8 + pointSphere.getCosLa() * d10;
        double d14 = Math.toDegrees(Math.asin(d13));
        double d15 = Math.abs(d13) == 1.0 ? pointSphere.longitude() : (d11 == 0.0 ? (double)(d12 > 0.0 ? 90 : -90) : (d11 > 0.0 ? Math.toDegrees(Math.atan(d12 / d11)) : (d11 < 0.0 ? 180.0 + Math.toDegrees(Math.atan(d12 / d11)) : 0.0)));
        if (d15 > 180.0) {
            d15 -= 360.0;
        }
        return new PointSphere(d15, d14);
    }
}

