/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class JImage
extends JComponent {
    private Color couleur;
    private BufferedImage image;
    private Dimension tailleComposant;

    public JImage(Color color, BufferedImage bufferedImage, Dimension dimension) {
        if (color == null) {
            throw new IllegalArgumentException("La couleur doit \u00eatre renseign\u00e9e");
        }
        this.image = bufferedImage;
        this.couleur = color;
        this.tailleComposant = dimension;
        this.ajusterTaille();
    }

    private void ajusterTaille() {
        Dimension dimension = this.tailleComposant != null ? this.tailleComposant : (this.image != null ? new Dimension(this.image.getWidth(), this.image.getHeight()) : new Dimension(0, 0));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
    }

    public void modifCouleur(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("La couleur doit \u00eatre renseign\u00e9e");
        }
        this.couleur = color;
    }

    public void modifImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.ajusterTaille();
    }

    public void modifTaille(Dimension dimension) {
        this.tailleComposant = dimension;
        this.ajusterTaille();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics graphics2 = bufferedImage.getGraphics();
        graphics2.setColor(this.couleur);
        graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            graphics2.drawImage(this.image, 0, 0, this);
        }
        graphics.drawImage(bufferedImage, 0, 0, this);
    }
}

