/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.igraphique.dessin.hachures;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ContextePeintureHachures
implements PaintContext {
    private static ColorModel modeleCouleurs = ColorModel.getRGBdefault();
    private Color couleur;
    private double espace;
    private double epaisseur;
    private int[] tableCouleurs;
    private int largeurFlou;
    private AffineTransform transf;

    public ContextePeintureHachures(Color color, double d, double d2, double d3, int n) {
        this.couleur = color;
        this.espace = d;
        this.epaisseur = d3;
        this.largeurFlou = n;
        this.tableCouleurs = this.creerTableCouleurs(color, n);
        this.transf = new AffineTransform();
        this.transf.rotate(1.5707963267948966 + d2);
    }

    public void modifCoulHachures(Color color) {
        if (!this.couleur.equals(color)) {
            this.couleur = color;
            this.tableCouleurs = this.creerTableCouleurs(this.couleur, this.largeurFlou);
        }
    }

    private int[] creerTableCouleurs(Color color, int n) {
        int n2 = color.getRGB() & 0xFFFFFF;
        int n3 = color.getAlpha();
        int[] nArray = new int[n];
        for (int i = 0; i < n / 2; ++i) {
            int n4 = (int)((double)i / (double)(n / 2 - 1) * (double)n3);
            nArray[i] = (n4 <<= 24) | n2;
            nArray[nArray.length - i - 1] = n4 | n2;
        }
        if (n % 2 != 0) {
            nArray[n / 2] = n3 << 24 | n2;
        }
        return nArray;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = modeleCouleurs.createCompatibleWritableRaster(n3, n4);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        double d = 0.0;
        double d2 = this.espace;
        int n5 = dataBufferInt.getOffset();
        int n6 = writableRaster.getWidth() - n3;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d3 = 0.0;
                double_.x = n + j;
                double_.y = n2 + i;
                this.transf.transform(double_, double_2);
                d3 = (double_2.x - d) / d2;
                d3 -= Math.floor(d3);
                double d4 = Math.abs(d3 * d2);
                nArray[n5++] = d4 < this.epaisseur ? this.tableCouleurs[(int)(d4 / this.epaisseur * (double)this.largeurFlou)] : 0;
            }
            n5 += n6;
        }
        return writableRaster;
    }

    @Override
    public ColorModel getColorModel() {
        return modeleCouleurs;
    }

    @Override
    public void dispose() {
    }
}

