/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.stockage;

import fr.histoiremondiale.histoire.ConfigAppli;
import fr.histoiremondiale.histoire.DonneesHistoriques;
import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.igraphique.FenPrincipale;
import fr.histoiremondiale.histoire.utiles.es.fichiers.Proprietes;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class AccesDonneesConfiguration {
    private static final String ENCODAGE_FIC_CONFIG = "UTF-8";
    private static final String CHEM_FIC_CONFIG = System.getProperty("user.home") + File.separator + ".config/histoiremondiale/histoire.conf".replace('/', File.separatorChar);

    public void sauverConfig(HistoireMondiale histoireMondiale) throws IOException {
        EtatAppli etatAppli = histoireMondiale.etat();
        FenPrincipale fenPrincipale = histoireMondiale.fenPrincipale();
        Properties properties = new Properties();
        if (histoireMondiale.config().chemRepDonneesLuConf() != null) {
            properties.put("chemRepDonnees", histoireMondiale.config().chemRepDonneesLuConf());
        }
        properties.put("longitude", "" + etatAppli.longitude());
        properties.put("latitude", "" + etatAppli.latitude());
        properties.put("loupe", "" + etatAppli.loupe());
        properties.put("annee", "" + etatAppli.annee());
        properties.put("nomRegionCourante", etatAppli.civilisationSelectionnee() == null ? "" : etatAppli.civilisationSelectionnee().nom());
        properties.put("verrouillageRegionActif", "" + etatAppli.suiviCivilisationSelectionnee());
        properties.put("symboleAttenteTracer", "" + etatAppli.symboleAttenteTracer());
        properties.put("texteSurvolFondClair", "" + etatAppli.texteSurvolFondClair());
        properties.put("posSeparateurCarteNavig", "" + fenPrincipale.posSeparateurPanneaux());
        properties.put("simpleClicFermerParagraphes", "" + etatAppli.simpleClicFermerParagraphes());
        properties.put("moletteGlisseDeUn", "" + etatAppli.moletteGlisseDeUn());
        properties.put("affParagraphesHtmlGeneres", "" + etatAppli.affParagraphesHtmlGeneres());
        properties.put("deplAnnees", "" + etatAppli.deplAnnees());
        properties.put("deplCoordonnees", "" + etatAppli.deplEspace());
        properties.put("fleuvesVisibles", "" + etatAppli.fleuvesAffiches());
        properties.put("infobullesCarte", "" + etatAppli.infobullesCarte());
        properties.put("meridiensEtParallelesAffiches", "" + etatAppli.meridiensParallelesAffiches());
        if (etatAppli.chemRepSauvCartes() != null) {
            properties.put("chemRepSauvCartes", etatAppli.chemRepSauvCartes());
        }
        if (etatAppli.chemRepSauvParagraphes() != null) {
            properties.put("chemRepSauvParagraphes", etatAppli.chemRepSauvParagraphes());
        }
        if (etatAppli.chemRepVueParagraphes() != null) {
            properties.put("chemRepVueParagraphes", etatAppli.chemRepVueParagraphes());
        }
        Proprietes.sauverProprietes(properties, "Configuration Histoire mondiale", CHEM_FIC_CONFIG, ENCODAGE_FIC_CONFIG);
    }

    public ConfigAppli chargerConfigGenerale() throws IOException {
        Properties properties = Proprietes.chargerProprietes(CHEM_FIC_CONFIG, ENCODAGE_FIC_CONFIG);
        String string = this.lireChaine(properties, "chemRepDonnees", null);
        String string2 = string == null ? "donnees" : string.replace('/', File.separatorChar);
        return new ConfigAppli(string2, string);
    }

    public EtatAppli chargerEtatAppli(DonneesHistoriques donneesHistoriques) throws IOException {
        Properties properties = Proprietes.chargerProprietes(CHEM_FIC_CONFIG, ENCODAGE_FIC_CONFIG);
        EtatAppli etatAppli = new EtatAppli();
        etatAppli.modifLongitude(this.lireDouble(properties, "longitude", 20.0));
        etatAppli.modifLatitude(this.lireDouble(properties, "latitude", 40.0));
        etatAppli.modifLoupe(this.lireDouble(properties, "loupe", 0.0));
        etatAppli.modifAnnee(this.lireEntier(properties, "annee", 1));
        etatAppli.modifSuiviCivilisationSelectionnee(this.lireBoolean(properties, "verrouillageRegionActif", true));
        etatAppli.modifSymboleAttenteTracer(this.lireBoolean(properties, "symboleAttenteTracer", true));
        etatAppli.modifTexteSurvolFondClair(this.lireBoolean(properties, "texteSurvolFondClair", false));
        etatAppli.modifSimpleClicFermerParagraphes(this.lireBoolean(properties, "simpleClicFermerParagraphes", false));
        etatAppli.modifPosSeparateurCarteNavig(this.lireDouble(properties, "posSeparateurCarteNavig", 0.66));
        etatAppli.modifMoletteGlisseDeUn(this.lireBoolean(properties, "moletteGlisseDeUn", true));
        etatAppli.modifAffParagraphesHtmlGeneres(this.lireBoolean(properties, "affParagraphesHtmlGeneres", false));
        etatAppli.modifDeplAnnees(this.lireEntier(properties, "deplAnnees", 1));
        etatAppli.modifDeplEspace(this.lireEntier(properties, "deplCoordonnees", 1));
        etatAppli.modifFleuvesAffiches(this.lireBoolean(properties, "fleuvesVisibles", true));
        etatAppli.modifInfobullesCarte(this.lireBoolean(properties, "infobullesCarte", true));
        etatAppli.modifMeridiensParallelesAffiches(this.lireBoolean(properties, "meridiensEtParallelesAffiches", false));
        String string = this.lireChaine(properties, "nomRegionCourante", null);
        etatAppli.modifCivilisationSelectionnee(donneesHistoriques.civilisationDeNom(string));
        etatAppli.modifChemRepSauvCartes(this.lireChaine(properties, "chemRepSauvCartes", null));
        etatAppli.modifChemRepSauvParagraphes(this.lireChaine(properties, "chemRepSauvParagraphes", null));
        etatAppli.modifChemRepVueParagraphes(this.lireChaine(properties, "chemRepVueParagraphes", null));
        return etatAppli;
    }

    private String lireChaine(Properties properties, String string, String string2) {
        String string3 = (String)properties.get(string);
        return string3 == null || string3.isEmpty() ? string2 : string3.trim();
    }

    private int lireEntier(Properties properties, String string, int n) {
        String string2 = (String)properties.get(string);
        return string2 == null || string2.isEmpty() ? n : Integer.parseInt(string2.trim());
    }

    private boolean lireBoolean(Properties properties, String string, boolean bl) {
        String string2 = (String)properties.get(string);
        return string2 == null || string2.isEmpty() ? bl : Boolean.parseBoolean(string2.trim());
    }

    private double lireDouble(Properties properties, String string, double d) {
        String string2 = (String)properties.get(string);
        return string2 == null || string2.isEmpty() ? d : Double.parseDouble(string2.trim());
    }
}

