/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import fr.histoiremondiale.histoire.utiles.igraphique.Polices;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TexteCarte {
    private static final Color GRIS = MetalLookAndFeel.getControlShadow();
    private String[] lignes;
    private Font police;

    public static int hauteurTextes(TexteCarte texteCarte, TexteCarte texteCarte2, Graphics2D graphics2D) {
        return texteCarte.hauteur(graphics2D) + texteCarte2.hauteur(graphics2D);
    }

    public TexteCarte() {
        this(new String[0], null);
    }

    public TexteCarte(String[] stringArray, Font font) {
        this.lignes = stringArray;
        this.police = font;
    }

    public boolean estAffichable() {
        return this.lignes != null && this.lignes.length > 0 && this.police != null;
    }

    public int hauteur(Graphics2D graphics2D) {
        if (!this.estAffichable()) {
            return 0;
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.police);
        int n = 0;
        for (String string : this.lignes) {
            n = (int)((double)n + Polices.hauteur(string, graphics2D));
        }
        graphics2D.setFont(font);
        return n;
    }

    public int largeur(Graphics2D graphics2D) {
        if (!this.estAffichable()) {
            return 0;
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.police);
        int n = 0;
        for (String string : this.lignes) {
            n = (int)Math.max((double)n, Polices.largeur(string, graphics2D));
        }
        graphics2D.setFont(font);
        return n;
    }

    public void tracerLignesCentrees(Graphics2D graphics2D, int n, int n2, boolean bl) {
        if (!this.estAffichable()) {
            return;
        }
        Font font = graphics2D.getFont();
        int n3 = this.largeur(graphics2D);
        int n4 = this.hauteur(graphics2D);
        graphics2D.setFont(this.police);
        if (bl) {
            n2 += 4;
        }
        int n5 = n2;
        for (String string : this.lignes) {
            int n6 = (int)Polices.largeur(string, graphics2D);
            int n7 = n + (n3 - n6) / 2;
            graphics2D.drawString(string, n7, n5 + (int)Polices.elevation(string, graphics2D));
            n5 = (int)((double)n5 + Polices.hauteur(string, graphics2D));
        }
        if (bl) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(GRIS);
            graphics2D.draw3DRect(n - 1, n2 - 1, n3 + 2, n4, false);
            graphics2D.setColor(color);
        }
        graphics2D.setFont(font);
    }
}

