/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BarreTemps
extends JComponent
implements MouseListener,
MouseMotionListener {
    private int mini;
    private int maxi;
    private int valeur;
    private int pas;
    private int xHautGauche;
    private int yHautGauche;
    private int xBasDroite;
    private int yBasDroite;
    private int largeurBarre;
    private int xGaucheCurseur;
    private int xDroiteCurseur;
    private static final int HAUTEUR_BARRE = 6;
    private static final int MARGE = 20;
    private static final int[][] FLECHE_GAUCHE = new int[][]{{0, 0, -7, -7, 0, 0}, {0, -5, 2, 3, 10, 5}};
    private static final int[][] FLECHE_DROITE = new int[][]{{0, 0, 7, 7, 0, 0}, {5, 10, 3, 2, -5, 0}};
    private static final int[][] CURSEUR = new int[][]{{-6, 0, 6, 6, -6}, {3, 9, 3, -5, -5}};
    private static final int[] MARQUES = new int[]{-3000, -2000, -1000, 0, 1000, 2000};
    private static final Color BLANC = MetalLookAndFeel.getWhite();
    private static final Color GRIS_CLAIR = (Color)UIManager.get("Slider.altTrackColor");
    private static final Color GRIS = MetalLookAndFeel.getControlShadow();
    private static final Color GRIS_FONCE = MetalLookAndFeel.getPrimaryControlShadow();
    private static final Color SOMBRE = MetalLookAndFeel.getPrimaryControlDarkShadow();
    private static final Color FOND = new Color(238, 238, 238);
    private boolean SourisPresseeDansCurseur;
    private Timer timer = this.createTimer();
    private int xSouris;
    private long tempo;

    public BarreTemps(int n, int n2, int n3, int n4) {
        if (n < n2) {
            this.mini = n;
            this.maxi = n2;
        } else {
            this.mini = n2;
            this.maxi = n;
        }
        this.valeur = n3;
        if (n3 < this.mini) {
            this.valeur = this.mini;
        }
        if (n3 > this.maxi) {
            this.valeur = this.maxi;
        }
        this.pas = n4;
        if (n4 > (n2 - n) / 2) {
            this.pas = (n2 - n) / 2;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getValeur() {
        return this.valeur;
    }

    public int getMini() {
        return this.mini;
    }

    public int getMaxi() {
        return this.maxi;
    }

    public int getPas() {
        return this.pas;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1200, 55);
    }

    private ChangeListener[] getChangeValeurListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(FOND);
        graphics2D.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
        this.yBasDroite = this.yHautGauche = (this.getHeight() - 6) / 2;
        this.xHautGauche = 20;
        this.xBasDroite = this.getWidth() - 20;
        this.largeurBarre = this.getWidth() - 40;
        int n2 = Math.round(this.largeurBarre * (this.getValeur() - this.getMini()) / (this.getMaxi() - this.getMini()));
        int[] nArray = new int[12];
        int[] nArray2 = new int[12];
        for (n = 0; n < 6; ++n) {
            nArray[n] = this.xHautGauche - 6 + FLECHE_GAUCHE[0][n];
            nArray2[n] = this.yHautGauche + FLECHE_GAUCHE[1][n];
        }
        for (n = 6; n < 12; ++n) {
            nArray[n] = this.xBasDroite + 6 + FLECHE_DROITE[0][n - 6];
            nArray2[n] = this.yBasDroite + FLECHE_DROITE[1][n - 6];
        }
        graphics2D.setColor(SOMBRE);
        graphics2D.drawPolygon(nArray, nArray2, 12);
        this.dessineBarre(graphics2D, n2);
        this.dessineFlecheGauche(graphics2D, nArray[1], nArray2[1]);
        this.dessineFlecheDroite(graphics2D, nArray[10], nArray2[10]);
        this.dessineMarques(graphics2D, n2);
        this.dessineCurseur(graphics2D, n2);
    }

    private void dessineBarre(Graphics2D graphics2D, int n) {
        graphics2D.setColor(BLANC);
        graphics2D.drawLine(this.xHautGauche - 5, this.yHautGauche + 1, this.xHautGauche + n, this.yHautGauche + 1);
        graphics2D.setColor(GRIS_CLAIR);
        graphics2D.drawLine(this.xHautGauche - 5, this.yHautGauche + 2, this.xHautGauche + n, this.yHautGauche + 2);
        graphics2D.setColor(GRIS);
        graphics2D.drawLine(this.xHautGauche - 5, this.yHautGauche + 3, this.xHautGauche + n, this.yHautGauche + 3);
        graphics2D.setColor(GRIS_FONCE);
        graphics2D.drawLine(this.xHautGauche - 5, this.yHautGauche + 4, this.xHautGauche + n, this.yHautGauche + 4);
        graphics2D.setColor(GRIS_FONCE);
        graphics2D.drawLine(this.xHautGauche + n + 1, this.yHautGauche + 1, this.xBasDroite + 5, this.yHautGauche + 1);
    }

    private void dessineFlecheGauche(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(BLANC);
        graphics2D.drawLine(n - 1, n2 + 2, n - 1, n2 + 2);
        graphics2D.drawLine(n - 1, n2 + 3, n - 2, n2 + 3);
        graphics2D.drawLine(n - 1, n2 + 4, n - 3, n2 + 4);
        graphics2D.drawLine(n - 1, n2 + 5, n - 4, n2 + 5);
        graphics2D.drawLine(n, n2 + 6, n - 5, n2 + 6);
        graphics2D.setColor(GRIS_CLAIR);
        graphics2D.drawLine(n, n2 + 7, n - 6, n2 + 7);
        graphics2D.setColor(GRIS);
        graphics2D.drawLine(n, n2 + 8, n - 6, n2 + 8);
        graphics2D.setColor(GRIS_FONCE);
        graphics2D.drawLine(n, n2 + 9, n - 5, n2 + 9);
        graphics2D.drawLine(n - 1, n2 + 10, n - 4, n2 + 10);
        graphics2D.drawLine(n - 1, n2 + 11, n - 3, n2 + 11);
        graphics2D.drawLine(n - 1, n2 + 12, n - 2, n2 + 12);
        graphics2D.drawLine(n - 1, n2 + 13, n - 1, n2 + 13);
    }

    private void dessineFlecheDroite(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(GRIS_FONCE);
        graphics2D.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        graphics2D.drawLine(n + 1, n2 + 3, n + 2, n2 + 3);
        graphics2D.drawLine(n + 1, n2 + 4, n + 3, n2 + 4);
        graphics2D.drawLine(n + 1, n2 + 5, n + 4, n2 + 5);
        graphics2D.drawLine(n, n2 + 6, n + 5, n2 + 6);
    }

    private void dessineMarques(Graphics2D graphics2D, int n) {
        graphics2D.setColor(Color.BLACK);
        String string = Integer.valueOf(this.getValeur()).toString();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = this.xHautGauche + n - fontMetrics.stringWidth(string) / 2;
        int n4 = this.yHautGauche - n2 / 2;
        graphics2D.drawString(string, n3, n4);
        for (int i = 1; i <= MARQUES.length; ++i) {
            string = (MARQUES[i - 1] == 0 ? "" : Integer.valueOf(MARQUES[i - 1])).toString();
            int n5 = Math.round(this.largeurBarre * (MARQUES[i - 1] - this.getMini()) / (this.getMaxi() - this.getMini()));
            n3 = Math.round(this.xHautGauche + n5 - fontMetrics.stringWidth(string) / 2);
            n4 = this.yHautGauche + 3 * n2 / 2;
            graphics2D.drawLine(this.xHautGauche + n5, this.yHautGauche + 6, this.xHautGauche + n5, this.yHautGauche + 6 + n2 / 2);
            graphics2D.drawString(string, n3, n4);
        }
    }

    private void dessineCurseur(Graphics2D graphics2D, int n) {
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        for (int i = 0; i < 5; ++i) {
            nArray[i] = this.xHautGauche + n + CURSEUR[0][i];
            nArray2[i] = this.yHautGauche + CURSEUR[1][i];
        }
        graphics2D.setColor(SOMBRE);
        graphics2D.drawPolygon(nArray, nArray2, 5);
        graphics2D.setColor(GRIS);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 1, nArray[3] - 1, nArray2[4] + 1);
        graphics2D.setColor(GRIS);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 2, nArray[3] - 1, nArray2[4] + 2);
        graphics2D.setColor(GRIS_CLAIR);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 3, nArray[3] - 1, nArray2[4] + 3);
        graphics2D.setColor(GRIS_CLAIR);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 4, nArray[3] - 1, nArray2[4] + 4);
        graphics2D.setColor(BLANC);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 5, nArray[3] - 1, nArray2[4] + 5);
        graphics2D.setColor(BLANC);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 6, nArray[3] - 1, nArray2[4] + 6);
        graphics2D.setColor(BLANC);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 7, nArray[3] - 1, nArray2[4] + 7);
        graphics2D.setColor(GRIS_CLAIR);
        graphics2D.drawLine(nArray[4] + 1, nArray2[4] + 8, nArray[3] - 1, nArray2[4] + 8);
        graphics2D.setColor(GRIS_CLAIR);
        graphics2D.drawLine(nArray[4] + 2, nArray2[4] + 9, nArray[3] - 2, nArray2[4] + 9);
        graphics2D.setColor(GRIS);
        graphics2D.drawLine(nArray[4] + 3, nArray2[4] + 10, nArray[3] - 3, nArray2[4] + 10);
        graphics2D.setColor(GRIS);
        graphics2D.drawLine(nArray[4] + 4, nArray2[4] + 11, nArray[3] - 4, nArray2[4] + 11);
        graphics2D.setColor(GRIS_FONCE);
        graphics2D.drawLine(nArray[4] + 5, nArray2[4] + 12, nArray[3] - 5, nArray2[4] + 12);
        graphics2D.setColor(GRIS_FONCE);
        graphics2D.drawLine(nArray[4] + 6, nArray2[4] + 13, nArray[3] - 6, nArray2[4] + 13);
        this.xGaucheCurseur = nArray[0];
        this.xDroiteCurseur = nArray[2];
    }

    public void setValeur(int n) {
        if (n > this.maxi) {
            n = this.maxi;
        }
        if (n < this.mini) {
            n = this.mini;
        }
        if (n != this.valeur) {
            if (n == 0) {
                n = this.valeur < 0 ? 1 : -1;
            }
            this.valeur = n;
            this.repaint();
            this.fireValeurChangee(new ChangeEvent(this));
        }
    }

    public void changeValeurDe(int n) {
        if (n != 0) {
            this.setValeur(this.valeur + n);
        }
    }

    public void setPas(int n) {
        if (n > (this.maxi - this.mini) / 2) {
            n = (this.maxi - this.mini) / 2;
        }
        if (n < 0) {
            n = 0;
        }
        if (n != this.pas) {
            this.pas = n;
        }
    }

    private Timer createTimer() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (System.currentTimeMillis() - BarreTemps.this.tempo > 500L) {
                    if (BarreTemps.this.xSouris < BarreTemps.this.xHautGauche) {
                        BarreTemps.this.changeValeurDe(-1);
                    } else if (BarreTemps.this.xSouris < BarreTemps.this.xGaucheCurseur) {
                        BarreTemps.this.changeValeurDe(-BarreTemps.this.getPas());
                    } else if (BarreTemps.this.xSouris >= BarreTemps.this.xDroiteCurseur) {
                        if (BarreTemps.this.xSouris < BarreTemps.this.xBasDroite) {
                            BarreTemps.this.changeValeurDe(BarreTemps.this.getPas());
                        } else {
                            BarreTemps.this.changeValeurDe(1);
                        }
                    }
                }
            }
        };
        return new Timer(100, actionListener);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.xSouris = mouseEvent.getX();
        if (!this.SourisPresseeDansCurseur) {
            boolean bl = this.SourisPresseeDansCurseur = this.xSouris >= this.xGaucheCurseur && this.xSouris <= this.xDroiteCurseur;
        }
        if (!this.SourisPresseeDansCurseur) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.getX() < this.xHautGauche) {
                this.changeValeurDe(-1);
            } else if (mouseEvent.getX() < this.xGaucheCurseur) {
                this.changeValeurDe(-this.getPas());
            } else if (mouseEvent.getX() >= this.xDroiteCurseur) {
                if (mouseEvent.getX() < this.xBasDroite) {
                    this.changeValeurDe(this.getPas());
                } else {
                    this.changeValeurDe(1);
                }
            }
            this.tempo = System.currentTimeMillis();
            this.timer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.timer.stop();
        this.SourisPresseeDansCurseur = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.SourisPresseeDansCurseur) {
            this.setValeur((int)((double)this.getMini() + (double)(mouseEvent.getX() - 20) * (double)(this.getMaxi() - this.getMini()) / (double)this.largeurBarre));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected void fireValeurChangee(ChangeEvent changeEvent) {
        for (ChangeListener changeListener : this.getChangeValeurListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }
}

